<?php
// $Id: admin_product_stats.php 5 2008-12-12 05:55:19Z adgar $

require_once('../jpgraph.php');
require_once('../jpgraph_bar.php');
require_once('../../admin/admincfg.php');
require_once('imgcfg.php');

//source data
$year=date('Y');      
$month=date('m');
$startdate = array(
    'last_1year' => date('Y-m-d H:i:s', mktime(0, 0, 0, $month, 1, $year-1)),
    'last_3month' => date('Y-m-d H:i:s', mktime(0, 0, 0, $month-3, 1, $year)),
    'last_1month' => date('Y-m-d H:i:s', mktime(0, 0, 0, $month-1, 1, $year)),
);

$sum_sales_multicurrency1 = $db->getAssoc("SELECT t1.product_id, txn_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['credit_primary'], $startdate['last_1year']), DB_FETCHMODE_ASSOC, true);
$sum_chargeback_multicurrency1 = $db->getAssoc("SELECT key_one, t1.product_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['debit_chargeback'], $startdate['last_1year']), DB_FETCHMODE_ASSOC, true);

$sum_sales_multicurrency2 = $db->getAssoc("SELECT t1.product_id, txn_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['credit_primary'], $startdate['last_3month']), DB_FETCHMODE_ASSOC, true);
$sum_chargeback_multicurrency2 = $db->getAssoc("SELECT key_one, t1.product_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['debit_chargeback'], $startdate['last_3month']), DB_FETCHMODE_ASSOC, true);

$sum_sales_multicurrency3 = $db->getAssoc("SELECT t1.product_id, txn_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['credit_primary'], $startdate['last_1month']), DB_FETCHMODE_ASSOC, true);
$sum_chargeback_multicurrency3 = $db->getAssoc("SELECT key_one, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['debit_chargeback'], $startdate['last_1month']), DB_FETCHMODE_ASSOC, true);

$products_rs = $db->query("SELECT group_id, name FROM $param[dbprefix]groups");

if (0 != $products_rs->numRows()) {
    
    $top_data1 = $top_data2 = $top_data3 = array();
    
    while ($product_row = $products_rs->fetchRow(DB_FETCHMODE_ASSOC) ) {          
        $key_one = $product_row['group_id'];
        $key_two = substr($product_row['name'], 0, 20);
        //last year
        if (isset($sum_sales_multicurrency1[$key_one])) {
            $product_sales =& $sum_sales_multicurrency1[$key_one];
            for($k=0, $max=count($product_sales); $k<$max; $k++) {
                //sales
                $top_data1[$key_two] += moneyConvert($product_sales[$k]['amount'], $product_sales[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
                //chargeback
                $chargeback_key_one = $product_sales[$k]['txn_id'];
                if (isset($sum_chargeback_multicurrency1[$chargeback_key_one])) {
                    $chargeback =& $sum_chargeback_multicurrency1[$chargeback_key_one][0];
                    $top_data1[$key_two] += moneyConvert($chargeback['amount'], $chargeback['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
                }            
            }
        }
        //last 3 month
        if (isset($sum_sales_multicurrency2[$key_one])) {
            $product_sales =& $sum_sales_multicurrency2[$key_one];        
            for($k=0, $max=count($product_sales); $k<$max; $k++) {
                //sales
                $top_data2[$key_two] += moneyConvert($product_sales[$k]['amount'], $product_sales[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
                //chargeback
                $chargeback_key_one = $product_sales[$k]['txn_id'];
                if (isset($sum_chargeback_multicurrency2[$chargeback_key_one])) {
                    $chargeback =& $sum_chargeback_multicurrency2[$chargeback_key_one][0];
                    $top_data2[$key_two] += moneyConvert($chargeback['amount'], $chargeback['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
                }            
            }
        }
        //last 1 month
        if (isset($sum_sales_multicurrency3[$key_one])) {
            $product_sales =& $sum_sales_multicurrency3[$key_one];
            for($k=0, $max=count($product_sales); $k<$max; $k++) {
                //sales
                $top_data3[$key_two] += moneyConvert($product_sales[$k]['amount'], $product_sales[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
                //chargeback
                $chargeback_key_one = $product_sales[$k]['txn_id'];
                if (isset($sum_chargeback_multicurrency3[$chargeback_key_one])) {
                    $chargeback =& $sum_chargeback_multicurrency3[$chargeback_key_one][0];
                    $top_data3[$key_two] += moneyConvert($chargeback['amount'], $chargeback['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
                }
            }
        }
            
    }
    
    arsort($top_data1);

    if (count($top_data1) != 0) {
        //formete data for graph
        $i = 0;
        $dataX = $dataY0 = $dataY1 = $dataY2 = array();
        foreach ($top_data1 as $k => $v) {    
            $dataY0[] = $v;
            $dataY1[] = (float) $top_data2[$k];
            $dataY2[] = (float) $top_data3[$k];
            $dataX[] =  $k;
            if ($i>=4) break;
            $i++;    
        }
    } else {
        //null data 1
        $dataY0 = $dataY1 = $dataY2 = array(0);
        $dataX = array('');            
    }

} else {
    //null data 2
    $dataY0 = $dataY1 = $dataY2 = array(0);
    $dataX = array('');    
}
    
// Create the graph. These two calls are always required
$graph = new Graph(600,220,'');
$graph->img->SetMargin(60,140,30,30);       

//color
$graph->SetColor(array(233,242,255));
$graph->SetMarginColor(array(233,242,255));
$graph->legend->Pos(0.01,0.35,"right","center");   

// Create the bar plots
$b0plot = new BarPlot($dataY0);
$b0plot->SetFillColor("blue");
$b0plot->SetLegend(getTranslateText('TT_LAST_YEAR'));

$b1plot = new BarPlot($dataY1);
$b1plot->SetFillColor("orange");
$b1plot->SetLegend(getTranslateText('TT_LAST_3MOUNTH'));

$b2plot = new BarPlot($dataY2);
$b2plot->SetFillColor("red");
$b2plot->SetLegend(getTranslateText('TT_LAST_1MOUNTH'));

$gbplot = new GroupBarPlot(array($b0plot, $b1plot, $b2plot));
$graph->Add($gbplot);

$graph->SetScale("textlin");
//title
$title = getTranslateText('TT_PRODUCT_STATS');
$graph->title->Set($title);
SetFont($graph->title, FF_ARIALUNI, FS_NORMAL, 10);
SetFont($graph->legend, FF_ARIALUNI, FS_NORMAL, 8);

//x
$graph->xaxis->SetTickLabels($dataX);    
SetFont($graph->xaxis, FF_ARIALUNI, FS_NORMAL, 8);

//y
$currency = getCurrencyTextType(DEFAULT_JOIN_CURRENCY);
$currency_text = (!empty($currency['cur_symbol'])) ? ($currency['cur_symbol'] . ' - ' . $currency['cur_alpha3']) : $currency['cur_alpha3'];
$graph->yaxis->title->Set($currency_text);
$graph->yaxis->title->SetMargin(20); 
SetFont($graph->yaxis->title, FF_CURRENCY, FS_NORMAL, 9);
SetFont($graph->yaxis, FF_ARIALUNI, FS_NORMAL, 8);

// Display the graph
$graph->Stroke();

?>