<?php
// $Id: banner_text.inc.php 5 2008-12-12 05:55:19Z adgar $

function addTextBanner($groupid, $adtitle, $descr) {   
    global $db, $param;              
    if (empty($adtitle)) {
        return AFFPRO::raiseError('129'); //Missing Ad Title       
    }      
    if (empty($descr)) {
        return AFFPRO::raiseError('130'); //Missing Ad Content     
    }               
    //add into database
    $db->query("INSERT INTO $param[dbprefix]textads (group_id, title, addesc) VALUES (?, ?, ?)", array($groupid, $adtitle, $descr));    
    return true;   
}

function deleteTextBanner($banner_id) {   
        global $db, $param;     
        $db->query("DELETE FROM $param[dbprefix]textads WHERE textad_id=?", array($banner_id));
        return;
}

function createTextBannerHtmlCode($bannerid, $affid, $testmode=false) {
    global $db, $param;
    $rs = $db->query("SELECT * FROM $param[dbprefix]textads WHERE textad_id=?", array($bannerid));
    if ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $bannerHtmlCode = createTextBannerHtmlCode2($row, $affid, $testmode);
        return $bannerHtmlCode;     
    } else {            
        return;            
    }
}  

function createTextBannerHtmlCode2($bandata, $affid,  $testmode=false) {
    $http_base_url = rtrim(HTTP_ADDR, '/');    
    $bannerUrl = $http_base_url ."/" .BANNER_FOLDER ."/adscontainer.php?aff_id=$affid&ad_id=$bandata[textad_id]&cp=UTF-8"; 
    if ($testmode) {
            $bannerUrl .= '&testmode=1';
    }                          
    $bannerHtmlCode = "<script type=\"text/javascript\">
    <!--
    BoxWidth = \"220\";
    BoxHeight = \"80\";
    OutlineColor = \"#384D60\";
    TitleTextColor = \"#FFFFFF\";
    LinkColor = \"#435C74\";
    TextColor = \"#000000\";
    TextBackgroundColor = \"#FFF5CE\";
    //-->
    </script>
    <script type=\"text/javascript\" src=\"$bannerUrl\"></script>
    ";          
    return $bannerHtmlCode;
}

function updateTextBanner($banner_id, $group_id, $title, $description) {
    global $db, $param;
    if (empty($title)) {
        return AFFPRO::raiseError('129'); //Missing Ad Title       
    }      
    if (empty($description)) {
        return AFFPRO::raiseError('130'); //Missing Ad Content     
    }     
    $db->query("UPDATE $param[dbprefix]textads SET group_id=?, title=?, addesc=? WHERE textad_id=?", array(intval($group_id), $title,  $description, intval($banner_id)));
    return;
}

?>