<?php
// $Id: common.inc.php 5 2008-12-12 05:55:19Z adgar $

ob_start();
session_start();

/******************************
 * Include config file
 ******************************/
$tmp = dirname(__FILE__);
$tmp = substr($tmp,  0, strlen($tmp)  - strlen('include')) . 'config/config.php';
if(!file_exists($tmp))
{
    header('Location: ../install/install.php');
    exit();
}

/******************************
 * Declare global variables
 ******************************/
global $html_before_body, $db, $param;
$html_before_body = '';
if (!isset($param) && !is_array($param)) $param = array();

/******************************
 * Include config file
 ******************************/
require_once('config.php');

/******************************
 * MySQL connection
 ******************************/
require_once('DB.php');
$db = DB::factory('mysql');
if (function_exists('db_error_callback'))
{
    $db->setErrorHandling(PEAR_ERROR_CALLBACK, 'db_error_callback');
}
$db->connect($DSN_INFO);
$db->fetchmode = DB_FETCHMODE_ASSOC;


/******************************
 * Set MySQL character
 ******************************/
$mysql_ver = $db->getOne("SELECT VERSION()");
$param['dbcharacter'] = 'latin1';
$param['mysql_ver'] = $mysql_ver;
if (version_compare($mysql_ver, '4.1', '>=')) {
   $db->query("SET SESSION sql_mode=''");
   $db->query("set character set utf8");
   $param['dbcharacter'] = 'utf8';
}

/******************************
 * Load current locale string
 * and date format parameters
 ******************************/
$row = $db->getRow("SELECT direction, long_date_format, short_date_format, locale FROM $param[dbprefix]languages WHERE alpha2=?", array(getLanguageId()), DB_FETCHMODE_ASSOC);
$param['direction'] = $row['direction'];
$param['long_date_format'] = $row['long_date_format'];
$param['short_date_format'] = $row['short_date_format'];
$param['locale'] = $row['locale'];

/******************************
 * Define default country,
 * currency and language
 ******************************/
if (!defined('DEFAULT_JOIN_COUNTRY')) define('DEFAULT_JOIN_COUNTRY', getParamByName('def_join_country'));
if (!defined('DEFAULT_LANGUAGE')) define('DEFAULT_LANGUAGE', getParamByName('def_language'));
define('START_DATE_PERIOD', strtotime('2006-01-02 00:00:00'));
$unvisible_countries = array(0, 245, 2);
/******************************
* Set global parameters
 ******************************/
$param['selfname'] = basename($_SERVER['PHP_SELF']);

/******************************
* Include core libraries
 ******************************/
require_once('AffPro.php');
require_once('Placeholder.php');
require_once('HTML/FormPersister.php');
require_once('logmaker.inc.php');
require_once('types.inc.php');
require_once('currency.inc.php');

/******************************
 ******************************/
$affScript = new AFFPRO($db, $param);
$TRANSLATED_TEXT = array();
$affScript->setCurrentLocale($param['locale']);
$affScript->initializeTranslateBuffer($TRANSLATED_TEXT);

/**
 * Recursive function for unquoting data in GLOBAL arrays
 *
 * @param link to global array
 * @return true
 */
function stripslash_array(&$array){
    foreach ($array as $key => $value) {
        if(is_array($array[$key])) stripslash_array($array[$key]);
        else $array[$key] = stripslashes($value);
    }
    return true;
}

function addslash_array(&$array){
    foreach ($array as $key => $value) {
        if(is_array($array[$key])) addslash_array($array[$key]);
        else $array[$key] = addslashes($value);
    }
    return true;
}

function striptags_array(&$array){
    foreach ($array as $key => $value) {
        if(is_array($array[$key])) striptags_array($array[$key]);
        else $array[$key] = trim(strip_tags($value));
    }
    return true;
}

function getParamByName($paramname) {
  global $db, $paramBuffer;
  if (isset($paramBuffer[$paramname])) {
      $paramvalue = $paramBuffer[$paramname];
  } else {
        $paramBuffer = $db->getAssoc("SELECT param, value FROM config15", false, null, DB_FETCHMODE_ASSOC);
        $paramvalue = $paramBuffer[$paramname];
  }
  return $paramvalue;
}

function setParamByName($paramname, $paramvalue) {
    global $db;
    $value = $paramvalue;
    settype($value, 'string');
//    $db->query("UPDATE config15 SET value=? WHERE param=?", array($value, $paramname));
    $db->query("REPLACE INTO config15 VALUES (?, ?)", array($paramname, $value));
}

function checkAccess($role) {
    global $base;
    if($role != $_SESSION['role'])
    {
        session_destroy();
        session_start();
        $preg = "/^" . preg_quote(HTTP_ADDR, '/') . "/";
        if (!preg_match($preg, $_SERVER['HTTP_REFERER']))
            $_SESSION['redirect_url'] = $_SERVER['REQUEST_URI'];
        if($role=='A')
        {
            AFFPRO::redirect(HTTP_ADDR . 'admin/index.php');
        } else {
            AFFPRO::redirect(HTTP_ADDR . 'affiliate/login.php');
        }
    }
    return;
}

function starting($title='') {
    require_once('visualinterfacebuilder.php');
    global $xtpl, $db, $param, $base, $base1, $html_before_body;
    header('Content-type: text/html; charset=UTF-8');
    //include Xtemplate class
    require_once('xtemplate.class.php');
    //open mail template
    $tpl_filename = getTemplateFullPath('main.html');
    $xtpl=new XTemplate($tpl_filename);
    //open current template
    $tpl_filename = basename($_SERVER['PHP_SELF'], '.php') . '.html';
    $tpl_filename = getTemplateFullPath($tpl_filename);
    $xtpl->assign_file('CURRENTTEMPLATE', $tpl_filename);
    //assign template variables
    $GLOBALS['img_pref1']  = $db->getOne("SELECT value FROM $param[dbprefix]styles WHERE name='img_pref1'");

    $lng_id = getLanguageId();
    $vars = array(
      'base'=>$base,
      'base1'=>$base1,
      'selfname'=>$param['selfname'],
      'dir'=>$param['direction'],
      'short_date_format' => $param['short_date_format'],
      'before_body' => $html_before_body,
      'img_pref1' => $GLOBALS['img_pref1']
    );
    $foo = getParamByName('meta_title_' . $lng_id);
    $foo = str_replace(array("\n", "\r"), '', $foo);
    $vars['meta_title'] = htmlspecialchars($foo, ENT_COMPAT, 'UTF-8');
    $foo = getParamByName('meta_keywords_' . $lng_id);
    $foo = str_replace(array("\n", "\r"), '', $foo);
    $vars['meta_keywords'] = htmlspecialchars($foo, ENT_COMPAT, 'UTF-8');
    $foo = getParamByName('meta_description_' . $lng_id);
    $foo = str_replace(array("\n", "\r"), '', $foo);
    $vars['meta_description']  = htmlspecialchars($foo, ENT_COMPAT, 'UTF-8');
    unset($foo);
    foreach ($vars as  $k => $v) {
      $xtpl->assign($k, $v);
    }
    //draw template header
    draw_logotype_and_lng();
    //draw top tabs menu
    $GLOBALS['current_str_header'] = draw_tab_bar(isset($_SESSION['userid']));
    if (!is_null($title)) {
      $xtpl->assign('headertext', $GLOBALS['current_str_header'] . ((!empty($title)) ? ": $title" : ''));
    }
    $xtpl->parse('header.headertext');

}

function ending() {
    global $xtpl;
    $xtpl->parse('header');
    $xtpl->out('header');
    $xtpl->parse('template');
    $xtpl->out('template');
    $xtpl->parse((isset($_SESSION['userid'])) ? 'footer.registreduser' : 'footer.nonuser');
    $xtpl->parse('footer');
    $xtpl->out('footer');
    $c = ob_get_contents(); ob_end_clean();
    echo HTML_FormPersister::ob_formPersisterHandler($c);
    exit();
}

function get_interval($mon, $day, $year)
{
    global $per, $date_start, $date_end, $param;
    $i=1;
    for($month=1;$month<13;$month++)
    {
        $per[$i] = strftime($param['short_date_format'], mktime(0,0,0,$month,1,$year)) . "-" . strftime($param['short_date_format'], mktime(0,0,0,$month,15,$year));
        $date_start[$i] = strftime('%Y-%m-%d', mktime(0,0,0,$month,1,$year));
        $date_end[$i] = strftime('%Y-%m-%d', mktime(0,0,0,$month,15,$year));
        if($month == $mon && $day<16)
        {
            $cur=$i;
        }
        $i++;
        $maxDay = date("t", mktime(0,0,0,$month,1,$year));
        $per[$i] = strftime($param['short_date_format'], mktime(0,0,0,$month,16,$year))."-".strftime($param['short_date_format'], mktime(0,0,0,$month,$maxDay,$year));
        $date_start[$i] = strftime('%Y-%m-%d', mktime(0,0,0,$month,16,$year));
        $date_end[$i] = strftime('%Y-%m-%d', mktime(0,0,0,$month,$maxDay,$year));
        if($month == $mon && $day<=$maxDay && $day>15)
            $cur=$i;
        $i++;
    }
    return $cur;
}

function submenu(&$items) {
    global $xtpl;
    draw_navigation_leftbar($items, $GLOBALS['current_str_header']);
    draw_logout_leftbar($_SESSION['userid']);
    if(isset($_SESSION['role']) && $_SESSION['role']=='A')
        draw_adminn_todo_list();
    draw_lastviewed_leftbar($_SESSION['userid']);

    $xtpl->parse('header.leftbar');
    $xtpl->parse('header.topmenu');
    return;
}

function cuthtml($text) {
    $foo = strip_tags($text);
    return htmlentities($foo, ENT_COMPAT, 'UTF-8');
}

/**
 * Convert PHP scalar, array or hash to JS scalar/array/hash.
 */
function php2js($a) {
    $return = '';
    if (is_null($a))  $return = 'null';
    if ($a === false) $return = 'false';
    if ($a === true)  $return = 'true';
    if (is_scalar($a)) {
        $a = addslashes($a);
        $a = str_replace("\n", '\n', $a);
        $a = str_replace("\r", '\r', $a);
        $a = preg_replace('{(</)(script)}i', "$1'+'$2", $a); // for FORM loader
        $return = "$a";
    }
    return $return;
}


function getLanguageId() {
    global $db, $param;

    if (isset($_SESSION['language_alpha2']) && !isset($_GET['language'])) {
        $return = $_SESSION['language_alpha2'];
    } else {

        if (isset($_GET['language'])) {
            $browser_alpha2 = $_GET['language'];
        } elseif (isset($_COOKIE['lng_alpha2'])) {
            $browser_alpha2 = $_COOKIE['lng_alpha2'];
        }

        $language_rs= $db->query("SELECT alpha2 FROM $param[dbprefix]languages WHERE (alpha2=?) AND (installed=1) AND (enable=1)", array($browser_alpha2));
        if ($language_row = $language_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
            set_cookie('lng_alpha2', $language_row['alpha2'], 157680000);
            $return = $_SESSION['language_alpha2'] = $language_row['alpha2'];
        } else {
            $return = $_SESSION['language_alpha2'] = getParamByName('def_language');
        }
    }
    //always set cookie
    if (!isset($_COOKIE['lng_alpha2'])) {
        set_cookie('lng_alpha2', $return, 157680000);
    }
    return $return;
}



function getTranslateText($wordcode, $lng_alpha2='') {
    //PHP.TRANSLATED_TEXT.%word_code% in xtpl templates
    global $db, $param, $TRANSLATED_TEXT;
    $return = $wordcode;
    $curlng_alpha2_id = getLanguageId();

    if (empty($lng_alpha2) || ($curlng_alpha2_id == $lng_alpha2)) {
        if (!isset($TRANSLATED_TEXT[$wordcode])) {
            $tmp = $db->getOne("SELECT translate_text FROM $param[dbprefix]translation WHERE lng_alpha2=? AND word_code=?", array($curlng_alpha2_id, $wordcode));
            $TRANSLATED_TEXT[$wordcode] = (!empty($tmp)) ? $tmp : $wordcode;
        }
        $return = $TRANSLATED_TEXT[$wordcode];
    } else {
        $tmp = $db->getOne("SELECT translate_text FROM $param[dbprefix]translation WHERE lng_alpha2=? AND word_code=?", array($lng_alpha2, $wordcode));
        $return = (!empty($tmp)) ? $tmp : $wordcode;
    }

    return $return;
}

function params2text() {
    $numags = func_num_args();
    if ($numags == 0) return '';
    $foo = func_get_arg(0);
    if ($numags > 1 ) {
        $ags = func_get_args();
        for ($i=1; $i<$numags; $i++ ) {
            $foo = str_replace('%' . $i, $ags[$i], $foo);
        }
    }
    return $foo;
}

function updateLastviewed($userid, $def_filename, $transl_wordcode) {
    global $db, $param, $base;
    $return = false;
    if (!empty($userid) && !empty($transl_wordcode)) {
        $filename = $base . '/' . $def_filename;
        $db->query("REPLACE INTO $param[dbprefix]lastviewed (filename, visit_time, descr, visiter) VALUES(?, now(),?,?)", array($filename, $transl_wordcode, $userid));
    }
    return $return;
}


function set_cookie($cookie_name, $cookie_value, $cookie_livetime = 0) {
    $cookie_domain = '.' . str_replace('www.', '', $_SERVER['SERVER_NAME']);
    if (empty($cookie_livetime)) $cookie_livetime = getParamByName('clt_number') * getParamByName('clt_factor');
    setcookie($cookie_name, $cookie_value, time() + $cookie_livetime, '/', $cookie_domain);
    return;
}


function getTemplateFullPath($tpl_filename) {
    $primary_tpl_path = SCRIPT_REALPATH . DIRECTORY_SEPARATOR  .'templates' . DIRECTORY_SEPARATOR . PRIMARY_LANGUAGE . DIRECTORY_SEPARATOR . TPL_FOLDER . DIRECTORY_SEPARATOR . $tpl_filename;
    $custom_tpl_path = SCRIPT_REALPATH . DIRECTORY_SEPARATOR  .'templates' . DIRECTORY_SEPARATOR . getLanguageId() . DIRECTORY_SEPARATOR . TPL_FOLDER . DIRECTORY_SEPARATOR . $tpl_filename;
    $return = (file_exists($custom_tpl_path)) ? $custom_tpl_path : $primary_tpl_path;

    return $return;
}

function fix_abs_path($path) {
    return str_replace(array('/', '\\'), DIRECTORY_SEPARATOR, $path);
}
?>