<?php
// $Id: currency.inc.php 8 2009-08-06 04:52:51Z adgar $

require_once('HTTP/Client.php');

function getCurrencyTextType($cur_id, $iso_alpha_only=false) {
    global $db, $param, $currencyTextBuffer;   
    if (!isset($currencyTextBuffer)) {
        $currencyTextBuffer = $db->getAssoc("SELECT cur_id, cur_alpha3, cur_symbol, symbol_prefix FROM $param[dbprefix]currency", false, null, DB_FETCHMODE_ASSOC);                    
    }
    $currency =& $currencyTextBuffer[$cur_id];
    if ($iso_alpha_only)
        $return = $currency['cur_alpha3'];
    else
        $return = (!empty($currency['cur_symbol'])) ? $currency : array('cur_alpha3'=>$currency['cur_alpha3'], 'cur_symbol'=>$currency['cur_alpha3'], 'symbol_prefix'=>0);
    return $return;
}

function moneytextformat($amount, $curency_id, $no_cyrrency = false, $iso_alpha_only = false){
    $amount = abs($amount);
    //TODO:
//    $foo = strpos((string)$amount, '.');
//    $famount = ($foo !== false) ? substr($amount, 0, $foo+3) : sprintf("%.2f", $amount);
    $famount = sprintf("%.2f", $amount);
    //
    if ($curency_id == 392) $famount = sprintf("%d", $amount); //for JPY
    if ($no_cyrrency) {
        return $famount;
    } else {
        $currency = getCurrencyTextType($curency_id, $iso_alpha_only);
        if ($iso_alpha_only) {
            $ftext = "$famount $currency";
        } else {
            $ftext = ($currency['symbol_prefix'] == 1) ? "{$currency['cur_symbol']}{$famount}" : "{$famount}{$currency['cur_symbol']}";
        }
    }
   return $ftext;   
}

function moneyConvert($amount, $input_cur_id, $output_cur_id) {    
    $factor = getConvertFactor($input_cur_id, $output_cur_id);
    $return = $amount * $factor;
    return $return;
}

function getConvertFactor($input_cur_id, $output_cur_id) {
    global $db, $param, $CONVERT_FACTORS;
    $return = 1 ;
    if ($input_cur_id != $output_cur_id) {    
        $key = $input_cur_id . '2' . $output_cur_id;
        if (!isset($CONVERT_FACTORS[$key]))
            $CONVERT_FACTORS = $db->getAssoc("SELECT factor_id, factor_value FROM $param[dbprefix]currency_factors", false, null, DB_FETCHMODE_ORDERED);
        $return = isset($CONVERT_FACTORS[$key]) ? $CONVERT_FACTORS[$key] : 0;
    }
    return $return;
}

/**
 * Currency exchange rate API function
 *
 * These functions converts two currencies using exchange rates from Yahoo Finance.
 * The currency codes are standard ISO 3-letter codes, and you can find the details
 * here:
 *  http://www.oanda.com/site/help/iso_code.shtml
 */ 

function downloadFinanceFromYahoo($finance_param, $csvfile) {
  if (0 == intval(ini_get('safe_mode'))) set_time_limit(0);
  $quotes_csv = '';
  while(true) {  
    //file_get_contents
    $quotes_csv = @file_get_contents('http://finance.yahoo.com/d/quotes.csv?' . $finance_param);
    if (false !== $quotes_csv) {  
      break;
    }
    //curl
    $ch = curl_init('http://download.finance.yahoo.com/d/quotes.csv?' . $finance_param);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $quotes_csv = curl_exec($ch);
    curl_close($ch);
    if (!empty($quotes_csv)) {
      break;
    }         
    //sosket
    $client  =& new HTTP_Client();    
    $client->get('http://finance.yahoo.com/d/quotes.csv?' . $finance_param);
    $sosket_reply = $client->currentResponse(); 
    if (200 == $sosket_reply['code']) {
      $quotes_csv = $sosket_reply['body'];
      break;
    }    
    //break
    break;
  }
  //save csv file
  $csv = @fopen($csvfile, 'w');
  if ($csv) {
    fwrite($csv, $quotes_csv);
    @fclose($csv);
    return true;
  }
  return false;    
}

function updateAllConvertFactors() {
  global $db, $param; 
  $finance_param = 'f=sl1&s='; //set quotes.csv format
  //generate finance params
  $currencies = $db->getAll("SELECT cur_id, cur_alpha3 FROM $param[dbprefix]currency WHERE enabled=1", null, DB_FETCHMODE_ORDERED);
  $foo1 = $currencies;
  $factors = array();
  for ($i=0,$m=count($currencies); $i<$m; $i++) {
    for ($i1=0,$m1=count($foo1); $i1<$m1; $i1++) {      
      $k = $currencies[$i][0] . 2 . $foo1[$i1][0];
      $finance_param .= $currencies[$i][1] . $foo1[$i1][1] . '=X+';
      $factors[] = array (
        'from' => $currencies[$i][0],
        'to'  =>  $foo1[$i1][0],
        'ex' => ($currencies[$i][0] == $foo1[$i1][0]) ? 1 : 0
      );
    }
  }
  unset($foo1, $currencies);
  //download quotes.csv
  $csvfile = AFFPRO::getResourcePath() . 'quotes.csv';
  downloadFinanceFromYahoo($finance_param, $csvfile);
  //load from quotes.csv and parse
  $quotes_csv = @file($csvfile);
  if ($quotes_csv !== false && 0!= count($quotes_csv)) {
    for($i=0, $m=count($quotes_csv); $i<$m; $i++) {
      if (isset($factors[$i])) {
        $k = explode(',', $quotes_csv[$i]);        
        $factors[$i]['ex'] = trim($k[1]);
      }
    }
  }
  unset($quotes_csv);
  //creaet sql
  $sql = array();
  foreach($factors as $k => $v) {
    $sql[] = sql_placeholder("(?, ?, ?, ?)", $v['from'] . '2' . $v['to'], ($v['from'] == $v['to']) ? 1 : $v['ex'], $v['from'], $v['to']);    
  }
  unset($factors);
  //execute sql
  if (0 != count($sql)) {  
    $sql_c = "REPLACE INTO {$param['dbprefix']}currency_factors(factor_id, factor_value, cur_from, cur_to) VALUES " . implode($sql, ',');
    $db->query("DELETE FROM {$param['dbprefix']}currency_factors");
    $db->query($sql_c);
  }
  return true;  
}

?>