<?php
// $Id: emailsender.inc.php 8 2009-08-06 04:52:51Z adgar $

require_once('Mail.php');

function getMailParameters($from) {
  $type = getParamByName('method');
  $result = array();
	switch($type) {
		case '1':
    $result = array(
      0 => 'sendmail',
      1 => array(
        'sendmail_path' => getParamByName('sendmail_path'),
        'sendmail_args' => getParamByName('sendmail_args'),
      )
    );
		break;

		case '2':
    $result = array(
      0 => 'smtp',
      1 => array(
        'host' => getParamByName('smtp_host'),
        'port' => getParambyName('smtp_port'),
        'auth' => (bool)getParamByName('smtp_auth'),
        'username' => getParamByName('smtp_username'),
        'password' => getParamByName('smtp_passw'),
        'localhost' => getParamByName('smtp_localhost'),
        'timeout' => getParamByName('smtp_timeout'),
        'verp' => false,
        'debug' => false,
      )
    );
    break;

		default:
    $result = array(
      0 => 'mail',
      1 => array('-f' . $from),
    );
    break;
	}

	return $result;
}


function sendUserMailFromTemplate($tpl_handle, $userid, $paramarray=array()) {
  global $param, $db, $users_types;
  $user_rs = $db->query("SELECT t1.*, t2.text_id FROM {$param['dbprefix']}users as t1 LEFT JOIN {$param['dbprefix']}users_ids as t2 ON t1.id=t2.userid WHERE t1.id=?", array($userid));
  if (!($user_row=$user_rs->fetchRow(DB_FETCHMODE_ASSOC))) return false;
  switch ((int)$user_row['usertype']) {
    case 1: $tpl_preix = 'admin_';
    break;
    case 2: $tpl_preix = 'admin_';
    break;
    case 3: $tpl_preix = 'admin_';
    break;
    case 4: $tpl_preix = 'affiliate_';
    break;
  }
  $tpl_header = $tpl_preix.'header';
  $tpl_footer = $tpl_preix.'footer';
  $tpl_body = $tpl_preix.$tpl_handle;
  $email_tpl_rs = $db->query("SELECT * FROM $param[dbprefix]email_tpl WHERE handle IN (?, ?, ?) AND enabled=1", array($tpl_body, $tpl_header, $tpl_footer));
  while ($email_tpl_row=$email_tpl_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
    if ($email_tpl_row['handle']==$tpl_header) $key = 0;
    else if ($email_tpl_row['handle']==$tpl_footer) $key = 2;
    else if ($email_tpl_row['handle']==$tpl_body) {
      $subject = $email_tpl_row['subject'];
	    $key = 1;
    }
    $body[$key] = stripslashes($email_tpl_row['body']);
  }
  if (!isset($body[1])) return true;
  ksort($body);
  $body = implode("\n\n", $body);
  $search = array(
    "/\[FirstName\]/i", //1
    "/\[LastName\]/i",  //2
    "/\[UserName\]/i",  //3
    "/\[Password\]/i",  //4
    "/\[SiteName\]/i",  //5
    "/\[SiteUrl\]/i",    //6
    "/\[AffiliateID\]/i", //7
    "/\[AffiliateRefID\]/i" //8
  );
  $replace = array(
    $user_row['first_name'], //1
    $user_row['last_name'], //2
    $user_row['name'], //3
    $user_row['password'], //4
    getParamByName('sitename'), //5
    rtrim(HTTP_ADDR, '/'), //6
    $userid, //7
    $user_row['text_id'] //8
  );
  if (count($paramarray)>0)
  foreach ($paramarray as $key => $value) {
	  $search[] = "/\[".$key."\]/i";
	  $replace[] = preg_quote($value);
  }
  //message text
  $text = preg_replace($search, $replace, $body);
  $text = stripslashes($text);
  $text = "<html><body>" . nl2br($text) . "</body></html>";
  //subject
  $subject = preg_replace($search, $replace, $subject);
  $subject = stripslashes($subject);
  //sent mail

  $from = getParamByName('admin_email');
  $parameters = getMailParameters($from);
  $mail_object =& Mail::factory($parameters[0], $parameters[1]);
  $headers = array (
  'From' => $from,
  'Subject' => '=?UTF-8?B?' . base64_encode($subject) . '?=',
  'MIME-Version' => '1.0',
  'Content-type' => 'text/html; charset=utf-8'
  );
  $mail_result = $mail_object->send($user_row['email'], $headers, $text);
  return  (PEAR::isError($mail_result))? $mail_result->getMessage() : true;
}

function sendAdminMailFromTemplate($tpl_handle, $userid, $paramarray=array()) {
  global $param, $db, $users_types;
  $user_rs = $db->query("SELECT t1.*, t2.text_id FROM {$param['dbprefix']}users as t1 LEFT JOIN {$param['dbprefix']}users_ids as t2 ON t1.id=t2.userid WHERE t1.id=?", array($userid));
  if (!($user_row=$user_rs->fetchRow(DB_FETCHMODE_ASSOC))) return false;
  switch ((int)$user_row['usertype']) {
    case 1: $tpl_preix = 'admin_';
    break;
    case 2: $tpl_preix = 'admin_';
    break;
    case 3: $tpl_preix = 'admin_';
    break;
    case 4: $tpl_preix = 'affiliate_';
    break;
  }
  $tpl_header = $tpl_preix.'admheader';
  $tpl_footer = $tpl_preix.'admfooter';
  $tpl_body = $tpl_preix.$tpl_handle;
  $email_tpl_rs = $db->query("SELECT * FROM $param[dbprefix]email_tpl WHERE handle IN (?, ?, ?) AND enabled=?", array($tpl_body, $tpl_header, $tpl_footer, 1));
  while ($email_tpl_row=$email_tpl_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
    if ($email_tpl_row['handle']==$tpl_header) $key = 0;
    else if ($email_tpl_row['handle']==$tpl_footer) $key = 2;
    else if ($email_tpl_row['handle']==$tpl_body) {
    	$subject = $email_tpl_row['subject'];
		  $key = 1;
	  }
	  $body[$key] = stripslashes($email_tpl_row['body']);
  }
  if (!isset($body[1])) return true;
  ksort($body);
  $body = implode("\n\n", $body);
  $search = array(
	  "/\[FirstName\]/i", //1
	  "/\[LastName\]/i",  //2
	  "/\[UserName\]/i",  //3
	  "/\[Password\]/i",  //4
	  "/\[SiteName\]/i",  //5
    "/\[SiteUrl\]/i",    //6
    "/\[AffiliateID\]/i", //7
    "/\[AffiliateRefID\]/i" //8
  );
  $replace = array(
	  $user_row['first_name'], //1
	  $user_row['last_name'], //2
	  $user_row['name'], //3
	  $user_row['password'], //4
    getParamByName('sitename'), //5
    rtrim(HTTP_ADDR, '/'), //6
    $userid, //7
    $user_row['text_id'] //8
  );
  if (count($paramarray)>0)
	  foreach ($paramarray as $key => $value) {
		  $search[] = "/\[".$key."\]/i";
		  $replace[] = preg_quote($value);
	  }

  //message text
  $text = preg_replace($search, $replace, $body);
  $text = stripslashes($text);
  $text = "<html><body>" . nl2br($text) . "</body></html>";
    //subject
  $subject = preg_replace($search, $replace, $subject);
  $subject= stripslashes($subject);

  $adminemail = getParamByName('admin_email');
  $parameters = getMailParameters($adminemail);
  $mail_object =& Mail::factory($parameters[0], $parameters[1]);
  $headers = array(
  'From'=>$adminemail,
  'Subject'=> '=?UTF-8?B?' . base64_encode($subject) . '?=',
  'MIME-Version' => '1.0',
  'Content-type'=> 'text/html; charset=utf-8'
  );
  $mail_result = $mail_object->send($adminemail, $headers, $text);
  return (PEAR::isError($mail_result))? $mail_result->getMessage() : true;
}

function sendMailToUsers($usertype, $alias_number, $subject, $body) {
  global $param, $db;
  switch ($alias_number) {
    //All Affiliates
    case 1: $user_emails = $db->getCol("SELECT email FROM $param[dbprefix]users WHERE usertype=?", 0, array($usertype));
    break;
    //Only Approved Affiliates
    case 2: $user_emails = $db->getCol("SELECT email FROM $param[dbprefix]users WHERE usertype=? AND approved=1", 0, array($usertype));
    break;
    //Only Non-Approved Affiliates
    case 3: $user_emails = $db->getCol("SELECT email FROM $param[dbprefix]users WHERE usertype=? AND approved=0", 0, array($usertype));
    break;
  }
  if (0 == count($user_emails)) {
    return "<span class=\"note\">".getTranslateText(148)."</span>";
  }
  $from = getParamByName('admin_email');
  $parameters = getMailParameters($from);
  $mail_object =& Mail::factory($parameters[0], $parameters[1]);
  $headers = array(
  'From' => $from,
  'Subject'=> '=?UTF-8?B?' . base64_encode($subject) . '?=',
  'MIME-Version' => '1.0',
  'Content-type' => 'text/html; charset=utf-8'
  );
  $text = "<html><body>" . nl2br($body) . "</body></html>";
  foreach ($user_emails as $to) {
    $mail_result = $mail_object->send($to, $headers, $text);
    if (PEAR::isError($mail_result)) break;
  }
  return (PEAR::isError($mail_result))? ("<span class=\"warning\">".$mail_result->getMessage()."</span>") : ("<span class=\"note\">".getTranslateText(148)."</span>");

}

?>