<?php
// $Id: filters.inc.php 8 2009-08-06 04:52:51Z adgar $

require_once('htmlelements.inc.php');

//date transform
$date_patterns = array (
    "/(\d{2})\.(\d{2})\.(\d{4})/"
);

$date_replacements = array (
    "\$3-\$2-\$1"
);

//insert

function insertTransactionFilter($xtpl_label_name, $xtpl_tpl_filename, $xtpl_section_name) {
    global $xtpl, $transaction_types, $db, $param, $unvisible_countries;
    $xtpl->assign_file($xtpl_label_name, $xtpl_tpl_filename);  
    //transaction types list
    foreach ($transaction_types as $k=>$v) {
        $txn_type_list[$v] =  getTransactionTextType($v);
    }
    //country list
    $sql = sql_placeholder("SELECT cnumber, cname FROM $param[dbprefix]countries WHERE lang_id=? AND cnumber NOT IN (?@) ORDER BY cname", getLanguageId(), $unvisible_countries);
    $countrylist=$db->getAssoc($sql, false,  null, DB_FETCHMODE_ORDERED);                
    // 
    foreach (array(
        'filter_hidden_data' => getHiddenFieldHtmlCode('filter', 'true'),
        'filter_txn_type' => getSelectFieldHtmlCode('filter_txn_type', $txn_type_list, $_REQUEST['filter_txn_type'], "class=\"text\" style=\"width:200px;\""),
        'filter_user_name' => getInputFieldHtmlCode('filter_user_name', $_REQUEST['filter_user_name'], "class=\"text\" maxlength=\"64\" style=\"width:200px;\""),
        'filter_date_from' => getInputFieldHtmlCode('filter_date_from', urldecode($_REQUEST['filter_date_from']), "class=\"text readonly calendar-input\" style=\"width:70px;\" readonly"),
        'filter_date_to' => getInputFieldHtmlCode('filter_date_to', urldecode($_REQUEST['filter_date_to']), "class=\"text readonly calendar-input\" style=\"width:70px;\" readonly"),
        'filter_country_list' => getSelectFieldHtmlCode('filter_country_list', $countrylist, $_REQUEST['filter_country_list'] ,"class=\"select\" style=\"width:200px;\"")
    ) as $k=>$v) {
        $xtpl->assign($k, $v);
    }
    $xtpl->parse($xtpl_section_name);
    return;
}


function insertQickStatsFilter($xtpl_label_name, $xtpl_tpl_filename, $xtpl_section_name) {
    global $xtpl, $param, $db, $users_types, $date_period_types;
    $xtpl->assign_file($xtpl_label_name, $xtpl_tpl_filename);  
    //affiliater list
    $user_list = $db->getAssoc("SELECT id, name FROM $param[dbprefix]users WHERE usertype=? ORDER BY name", false,  array($users_types['affiliater']), DB_FETCHMODE_ORDERED);                    
    //transaction period list   
    $txn_period_list = array(  
        $date_period_types['monthly_number'] => getTranslateText('TT_MONTHLY'),
        $date_period_types['half_monthly_number'] => getTranslateText('TT_HALF_MONTHLY'),
        $date_period_types['bi_weekly_number'] => getTranslateText('TT_BI_WEEKLY'),
        $date_period_types['weekly_number'] => getTranslateText('TT_WEEKLY'),
        $date_period_types['daily_number'] => getTranslateText('TT_DAILY')
    );
    //period    
    $now_time = time();
    $date_to = strftime($param['short_date_format'], $now_time);
    $date_from = strftime($param['short_date_format'], $now_time - 15768000); // minus one half-year
    //     
    foreach (array(
        'filter_hidden_data' => getHiddenFieldHtmlCode('filter', 'true', $_REQUEST['filter_user_name']),
        'filter_user_name' => getSelectFieldHtmlCode('filter_user_name', $user_list, $_REQUEST['filter_user_name'], "class=\"text\" maxlength=\"64\" style=\"width:200px;\""), 
        'filter_date_from' => getInputFieldHtmlCode('filter_date_from', (isset($_REQUEST['filter_date_from'])) ? urldecode($_REQUEST['filter_date_from']) : $date_from, "class=\"text readonly calendar-input\" style=\"width:70px;\" readonly"),
        'filter_date_to' => getInputFieldHtmlCode('filter_date_to', isset($_REQUEST['filter_date_to']) ? urldecode($_REQUEST['filter_date_to']) : $date_to, "class=\"text readonly calendar-input\" style=\"width:70px;\" readonly"),
        'filter_txn_period' => getSelectFieldHtmlCode('filter_txn_period', $txn_period_list, isset($_REQUEST['filter_txn_period']) ? $_REQUEST['filter_txn_period'] : $date_period_types['monthly_number'] ,"class=\"select\" style=\"width:200px;\"")        
    ) as $k=>$v) {
        $xtpl->assign($k, $v);
    }
    $xtpl->parse($xtpl_section_name);
    return;
}

function insertProductGroupFilter($xtpl_label_name, $xtpl_tpl_filename, $xtpl_section_name) {
    global $db, $param, $xtpl;
    $xtpl->assign_file($xtpl_label_name, $xtpl_tpl_filename);     
    $grouplist=$db->getAssoc("SELECT group_id, name FROM $param[dbprefix]groups ORDER BY group_id", false,  null, DB_FETCHMODE_ORDERED);
    foreach (array(
        'filter_group_list' => getSelectFieldHtmlCode('filter_group_list', $grouplist, $_REQUEST['filter_group_list'] ,"class=\"select\" style=\"width:200px;\"")
    ) as $k=>$v) {
        $xtpl->assign($k, $v);
    }
    $xtpl->parse($xtpl_section_name);
    return;
}

//get

function getTransactionFilterSqlCondition() {
    global $date_patterns, $date_replacements;
    $sql_q = '';
    if (isset($_REQUEST['active_filter']) && is_array($_REQUEST['active_filter'])) {    
        if (in_array('txn_type', $_REQUEST['active_filter']) && is_numeric($_REQUEST['filter_txn_type'])) {
            $tmp = addslashes($_REQUEST[filter_txn_type]);
            //$sql_q .= "AND (t1.txn_type = $tmp) ";
            //BEGIN TEMPORARY CODE
            global $transaction_types;
            if ($transaction_types['credit_recurring'] == $tmp) {
                $sql_q .= "AND (t1.txn_type = $tmp OR t1.is_recurring = 1) ";
            } else {
                $sql_q .= "AND (t1.txn_type = $tmp) ";            
            }
            //END TEMPORARY CODE
        }        
        if (in_array('user_name', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_user_name']))) {
            $tmp =  addslashes($_REQUEST['filter_user_name']);
            $sql_q .= "AND (t2.name like '%$tmp%') ";
        }
        if (in_array('date_from', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_date_from']))) {
            $date = preg_replace($date_patterns, $date_replacements, urldecode($_REQUEST['filter_date_from']));
            $date = strftime("%Y-%m-%d", strtotime($date));            
            $sql_q .= "AND (t1.create_date>='$date 00:00:00') ";
        }
        if (in_array('date_to', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_date_to']))) {
            $date = preg_replace($date_patterns, $date_replacements, urldecode($_REQUEST['filter_date_to']));
            $date = strftime("%Y-%m-%d", strtotime($date));            
            $sql_q .= "AND (t1.create_date<='$date 23:59:59') ";
        }
        if (in_array('country_list', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_country_list']))) {
            $country_id = addslashes($_REQUEST['filter_country_list']);
            $sql_q .= "AND (t1.country_id='$country_id') ";
        }      
    }
    return $sql_q;
}

function getQickStatsFilterSqlCondition() {
    global $param, $date_period_types, $date_patterns, $date_replacements;
    $sql_q = ''; 
    if (isset($_REQUEST['active_filter']) && is_array($_REQUEST['active_filter'])) {            
        if (in_array('user_name', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_user_name']))) {
            $tmp =  addslashes($_REQUEST['filter_user_name']);
            $sql_q .= "AND (t1.user_id like '%$tmp%') ";
        }      
           
        if (in_array('date_from', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_date_from']))) {
            $date = preg_replace($date_patterns, $date_replacements, urldecode($_REQUEST['filter_date_from']));
            $date = strftime("%Y-%m-%d", strtotime($date));            
            $sql_q .= "AND (t1.create_date>='$date 00:00:00') ";
        }
        if (in_array('date_to', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_date_to']))) {
            $date = preg_replace($date_patterns, $date_replacements, urldecode($_REQUEST['filter_date_to']));
            $date = strftime("%Y-%m-%d", strtotime($date));            
            $sql_q .= "AND (t1.create_date<='$date 23:59:59') ";
        }
                 
    } else {
        $now_time = time();
        $date_to = date('Y-m-d', $now_time);
        $date_from = date('Y-m-d', $now_time - 15768000); // minus one half-year        
        $sql_q .= "AND (t1.create_date>='$date_from 00:00:00') AND (t1.create_date<='$date_to 23:59:59') ";
    }
    $sql_q .= " GROUP BY t1.orig_cur_index, t1.txn_type"; 
    if (!isset($_REQUEST['filter_txn_period'])) $_REQUEST['filter_txn_period'] = $date_period_types['monthly_number'];
    switch (intval($_REQUEST['filter_txn_period'])) {
        case $date_period_types['half_monthly_number']: $sql_q .= ", t1.half_monthly_number";
        break;
        case $date_period_types['bi_weekly_number']: $sql_q .= ", t1.bi_weekly_number";
        break;
        case $date_period_types['weekly_number']: $sql_q .= ", t1.weekly_number";
        break;
        case $date_period_types['daily_number']: $sql_q .= ", t1.daily_number";
        break;
        default: $sql_q .= ", t1.monthly_number";
        break;                                                
    }
    return $sql_q;
}

function getTrafficFilterSqlCondition() {
    global $date_patterns, $date_replacements;
    $sql_q = '';
    if (isset($_REQUEST['active_filter']) && is_array($_REQUEST['active_filter'])) {    
        if (in_array('user_name', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_user_name']))) {
            $tmp = addslashes($_REQUEST['filter_user_name']);
            $sql_q .= "AND (t2.name like '%$tmp%') ";
        }
        if (in_array('date_from', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_date_from']))) {
            $date = preg_replace($date_patterns, $date_replacements, urldecode($_REQUEST['filter_date_from']));
            $date = strftime("%Y-%m-%d", strtotime($date));                 
            $sql_q .= "AND (t1.create_date>='$date  00:00:00') ";
        }
            if (in_array('date_to', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_date_to']))) {
            $date = preg_replace($date_patterns, $date_replacements, urldecode($_REQUEST['filter_date_to']));
            $date = strftime("%Y-%m-%d", strtotime($date));            
            $sql_q .= "AND (t1.create_date<='$date 23:59:59') ";
        }
    }
    return $sql_q;
}

function getProductGroupFilterSqlCondition() {
    $sql_q = '';
    if (isset($_REQUEST['active_filter']) && is_array($_REQUEST['active_filter'])) {    
        if (in_array('group_list', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_group_list']))) {
            $group_id = addslashes($_REQUEST['filter_group_list']);
            $sql_q .= "AND (t2.group_id='$group_id') ";
        }
    }
    return $sql_q;    
}


function getCountryFilterSqlCondition() {
    $sql_q = '';
    if (isset($_REQUEST['active_filter']) && is_array($_REQUEST['active_filter'])) {    
        if (in_array('country_list', $_REQUEST['active_filter']) && (!empty($_REQUEST['filter_country_list']))) {
            $cnumber = addslashes($_REQUEST['filter_country_list']);
            $sql_q .= "AND (t2.cnumber='$cnumber') ";
        }
    }
    return $sql_q;    
}

?>