<?php
// $Id: imagesgenerator.inc.php 5 2008-12-12 05:55:19Z adgar $

require_once('filesystem.inc.php');

function hex2rgb($hex) {
    $r = hexdec(substr($hex, 1, 2));
    $g = hexdec(substr($hex, 3, 2));
    $b = hexdec(substr($hex, 5, 2));

    return array("r" => $r, "g" => $g, "b" => $b);
}

function rgb2hex($rgb) {
    return sprintf("#%02X%02X%02X", $rgb[0], $rgb[1], $rgb[2]);
}

function generateMenuImages($out_path, $prefix, $hex_border_color, $hex_bgcolor, $w = 10, $h = 60) {
    $im = imagecreatetruecolor($w, $h);
    if (!is_resource($im)) return;

    $transparent_color = imagecolorallocate($im, 255, 0, 255);
    imagecolortransparent($im, $transparent_color);

    $bgcolor_rgb = hex2rgb($hex_bgcolor);
    $bgcolor = imagecolorallocate($im, $bgcolor_rgb['r'], $bgcolor_rgb['g'], $bgcolor_rgb['b']);
    $border_color_rgb = hex2rgb($hex_border_color);
    $border_color = imagecolorallocate($im, $border_color_rgb['r'], $border_color_rgb['g'], $border_color_rgb['b']);

    imagefilledrectangle($im, 0, 0, $w - 1, $h - 1, $bgcolor);
    imageline($im, 0, 0, $w - 1, 0, $border_color);
    imagepng($im, $out_path . $prefix . '_middle.png');

    imagefilledrectangle($im, 0, 0, $w - 1, $h - 1, $bgcolor);
    imageline($im, 0, 1, 0, $h - 1, $border_color);
    imageline($im, 1, 0, $w - 1, 0, $border_color);
    imagesetpixel($im, 0, 0, $transparent_color);
    imagepng($im, $out_path . $prefix . '_left.png');

    imagefilledrectangle($im, 0, 0, $w - 1, $h - 1, $bgcolor);
    imageline($im, $w - 1, 1, $w - 1, $h - 1, $border_color);
    imageline($im, 0, 0, $w - 2, 0, $border_color);
    imagesetpixel($im, 0, 0, $border_color);
    imagesetpixel($im, $w - 1, 0, $transparent_color);
    imagepng($im, $out_path . $prefix . '_right.png');
    imagedestroy($im);
}

function generateGradient($out_file, $hex_color1, $hex_color2, $h = 8) {
    $im = imagecreatetruecolor(1, $h);
    if (!is_resource($im)) return;

    $color1_rgb = hex2rgb($hex_color1);
    $color2_rgb = hex2rgb($hex_color2);

    $dr = ($color2_rgb['r'] - $color1_rgb['r'])/($h - 1);
    $dg = ($color2_rgb['g'] - $color1_rgb['g'])/($h - 1);
    $db = ($color2_rgb['b'] - $color1_rgb['b'])/($h - 1);
    $cur_r = $color1_rgb['r'];
    $cur_g = $color1_rgb['g'];
    $cur_b = $color1_rgb['b'];
    for ($i = 0; $i < $h; $i++) {
        $cur_color = imagecolorallocate($im, round($cur_r), round($cur_g), round($cur_b));
        imagesetpixel($im, 0, $i, $cur_color);
        $cur_r += $dr;
        $cur_g += $dg;
        $cur_b += $db;
    }
    imagepng($im, $out_file);
    imagedestroy($im);
}

function generateFromTemplate($input_file, $out_file, $hex_color, $new_color=null) {
    $color_rgb = hex2rgb($hex_color);
    $tmp_im = imagecreatefrompng($input_file);
    if (!is_resource($tmp_im)) return;

    $size = getimagesize($input_file);
    $im = imagecreatetruecolor($size[0], $size[1]);
    $color = imagecolorallocate($im, $color_rgb['r'], $color_rgb['g'], $color_rgb['b']);
    imagefilledrectangle($im, 0, 0, $size[0] - 1, $size[1] - 1, $color);

    if (!empty($new_color)) {
        $new_rgb = hex2rgb($new_color);
        $new_color = imagecolorallocate($tmp_im, $new_rgb['r'], $new_rgb['g'], $new_rgb['b']);
        for ($i = 0; $i < $size[0]; $i++) {
            for ($j = 0; $j < $size[1]; $j++) {
                $rgb = imagecolorat($tmp_im, $i, $j);
                if (((($rgb >> 16) & 0xFF) == 0) &&
                    ((($rgb >> 8)  & 0xFF) == 0) &&
                    ((($rgb)       & 0xFF) == 0))
                {
                    imagesetpixel($tmp_im, $i, $j, $new_color);
                }
            }
        }
    }

    imagecopy($im, $tmp_im, 0, 0, 0, 0, $size[0] - 1, $size[1] - 1);
    imagepng($im, $out_file);
    imagedestroy($im);
    imagedestroy($tmp_im);
}

function generateLanguagePanelImages($out_path, $color) {
    $im = imagecreate(36, 24);
    if (!is_resource($im)) return;

    $transparent_color = imagecolorallocate($im, 255, 0, 255);
    imagecolortransparent($im, $transparent_color);
    imagefilledrectangle($im, 0, 0, 35, 23, $transparent_color);
    $values = array(
       0,  0,
       24, 24,
       36, 24,
       36, 0
       );
    $color_rgb = hex2rgb($color);
    $color = imagecolorallocate($im, $color_rgb['r'], $color_rgb['g'], $color_rgb['b']);
    imagefilledpolygon($im, $values, 4, $color);
    imagepng($im, $out_path . 'lng_left_img.png');
    imagedestroy($im);
}

function generateImages() {
    global $db, $param;

    //load color params
    $_STYLES = $db->getAssoc("SELECT name, value FROM $param[dbprefix]styles");
    $sql_tail = '';

    //generate image resource path
    $res_path = AFFPRO::getResourcePath();
    $img_wr_path = $res_path . 'img1' . DIRECTORY_SEPARATOR;
    $img_pref1 = mt_rand();
    $img_pref2 = mt_rand();

    //delete old images
    $files = fs::dirget($img_wr_path);
    foreach($files as $file) {
        @unlink($img_wr_path . $file);
    }

    //create images for language panel
    $img = array(
    0 => 'lng_left_img.png'
    );
    generateLanguagePanelImages($img_wr_path, $_STYLES['LANGUAGE_PANEL_BGCOLOR']);
    for($i=0, $max=count($img); $i<$max; $i++) {
        $t1 = $img_pref1 . $img[$i];
        rename($img_wr_path . $img[$i], $img_wr_path . $t1);
        $sql_tail .= "('$img[$i]', '$t1'), ";
    }

    //create images for top and left menu
    $img = array(
    0 => 'otherTab',
    1 => 'currentTab',
    2 => 'lb_top'
    );
    generateMenuImages($img_wr_path, $img[0], $_STYLES['TOPMENU_BORDER_COLOR'], $_STYLES['TOPMENU_BGCOLOR']);
    generateMenuImages($img_wr_path, $img[1], $_STYLES['TOPMENU_BAR_BORDER_COLOR'], $_STYLES['TOPMENU_BAR_BGCOLOR']);
    generateMenuImages($img_wr_path, $img[2], $_STYLES['LEFTMENU_BOX_BORDER_COLOR'], $_STYLES['LEFTMENU_BOX_HEADER_BGCOLOR']);
    for($i=0, $max=count($img); $i<$max; $i++) {
        $f1 = $img[$i] . '_middle.png';
        $f2 = $img[$i] . '_left.png';
        $f3 = $img[$i] . '_right.png';
        $t1 = $img_pref1 . $f1;
        $t2 = $img_pref1 . $f2;
        $t3 = $img_pref1 . $f3;
        rename($img_wr_path . $f1, $img_wr_path . $t1);
        rename($img_wr_path . $f2, $img_wr_path . $t2);
        rename($img_wr_path . $f3, $img_wr_path . $t3);
        $sql_tail .= "('$f1', '$t1'), ('$f2', '$t2'), ('$f3', '$t3'),";
    }
    //create gradient images
    $img = array(
    0 => 'topmenu_01.png',
    1 => 'topmenu_02.png'
    );
    generateGradient($img_wr_path . $img[0], $_STYLES['TOPBANNER_BGCOLOR'], $_STYLES['TOPMENU_BAR_BORDER_COLOR']);
    generateGradient($img_wr_path . $img[1], $_STYLES['TOPMENU_BAR_BORDER_COLOR'], $_STYLES['CONTENT_BGCOLOR']);
    for($i=0, $max=count($img); $i<$max; $i++) {
        $t1 = $img_pref1 . $img[$i];
        rename($img_wr_path . $img[$i], $img_wr_path . $t1);
        $sql_tail .= "('$img[$i]', '$t1'), ";
    }
    //create arrow images for left menu
    $trimg_path = $res_path . 'img_t' . DIRECTORY_SEPARATOR;
    $img = array(
    'lb_handle01.png',
    'lb_handle02.png'
    );
    for($i=0, $max=count($img); $i<$max; $i++) {
        generateFromTemplate($trimg_path . $img[$i], $img_wr_path . $img[$i], $_STYLES['LEFTMENU_BOX_HEADER_BGCOLOR']);
        $t1 = $img_pref1 . $img[$i];
        rename($img_wr_path . $img[$i], $img_wr_path . $t1);
        $sql_tail .= "('$img[$i]', '$t1'), ";
    }
    //create images for dtree and dtree_white
    $trimg_path = $res_path . 'img_t' . DIRECTORY_SEPARATOR . 'dtree' . DIRECTORY_SEPARATOR;

    $img = array(
    'aff_root.png',
    'aff_folder.png',
    'aff_folderopen.png',
    'aff_base.png'
    );
    for($i=0, $max=count($img); $i<$max; $i++) {
        generateFromTemplate($trimg_path . $img[$i], $img_wr_path . $img_pref1 . $img[$i], $_STYLES['CONTENT_BGCOLOR']);
        generateFromTemplate($trimg_path . $img[$i], $img_wr_path . $img_pref2 . $img[$i], '#FFFFFF');
    }

    $rgb = hex2rgb($_STYLES['CONTENT_BGCOLOR']);
    $tmp = ($rgb['r']*0.3 + $rgb['g']*0.49 + $rgb['b']*0.11);
    $hex = rgb2hex(array((255 - $tmp), (255 - $tmp), (255 - $tmp)));

    $img = array(
    'empty.png',
    'joinbottom.png',
    'join.png',
    'line.png',
    'minus.png',
    'minusbottom.png',
    'nolines_minus.png',
    'nolines_plus.png',
    'plus.png',
    'plusbottom.png'
    );
    for($i=0, $max=count($img); $i<$max; $i++) {
        generateFromTemplate($trimg_path . $img[$i], $img_wr_path . $img_pref1 . $img[$i], $_STYLES['CONTENT_BGCOLOR'], $hex);
        generateFromTemplate($trimg_path . $img[$i], $img_wr_path . $img_pref2 . $img[$i], '#FFFFFF');
    }
    $sql_tail .= "('img_pref1', '$img_pref1'), ('img_pref2', '$img_pref2') ";
    //update image params
    if (!empty($sql_tail)) {
//        $sql_tail = rtrim($sql_tail, ', ');
        $db->query("REPLACE $param[dbprefix]styles (name, value) VALUES $sql_tail");
    }

    //chmod 644 for new files
    $files = fs::dirget($img_wr_path);
    foreach($files as $file) {
      chmod($img_wr_path . $file, 0644);
    }

}

?>