<?php
// $Id: initialization_db.inc.php 5 2008-12-12 05:55:19Z adgar $

/******************************    
* Initialization
 ******************************/ 
ini_set('memory_limit', '16M');
ob_start();  
session_start();

$os = (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') ? 'win' : 'nix';
if ('win' == $os) {
    if (!defined('DIRECTORY_SEPARATOR'))  define('DIRECTORY_SEPARATOR', '\\');
    if (!defined('PATH_SEPARATOR'))  define('PATH_SEPARATOR', ';');
    if (!defined('PHP_SHLIB_SUFFIX'))  define('PHP_SHLIB_SUFFIX', 'dll');
    if (!isset($_SERVER['QUERY_STRING'])) $_SERVER['QUERY_STRING'] = '';    
    if (strstr($_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS')) $_SERVER['REQUEST_URI'] = $_SERVER['PATH_INFO'] . '?' . $_SERVER['QUERY_STRING'];
} else {
    if (!defined('DIRECTORY_SEPARATOR'))  define('DIRECTORY_SEPARATOR', '/');
    if (!defined('PATH_SEPARATOR'))  define('PATH_SEPARATOR', ':');    
    if (!defined('PHP_SHLIB_SUFFIX'))  define('PHP_SHLIB_SUFFIX', 'so');
}

$foo = dirname(__FILE__);
$absbase = realpath(dirname(__FILE__) . '/../');
$include_path = array(
  './',
  $absbase,        
  $absbase . '/config',
  $absbase . '/lib',
  $absbase . '/include'
);

ini_set('include_path', implode(PATH_SEPARATOR, $include_path));
unset($os, $absbase, $foo);

/******************************    
 * Declare global variables
 ******************************/ 
global $db, $param;
if (!isset($param) && !is_array($param)) $param = array();

/******************************    
 * Include config file
 ******************************/ 
require_once('config.php');
require_once('DB.php');
$db = DB::factory('mysql');
if (function_exists('db_error_callback')) 
{
    $db->setErrorHandling(PEAR_ERROR_CALLBACK, 'db_error_callback');
}
$db->connect($DSN_INFO);
$db->fetchmode |= DB_FETCHMODE_ASSOC;

/******************************    
 * Set MySQL character 
 ******************************/ 
$mysql_ver = $db->getOne("SELECT VERSION()");
$param['dbcharacter'] = 'latain1';      
$param['mysql_ver'] = $mysql_ver; 
if (version_compare($mysql_ver, '4.1', '>')) {
   $db->query("set character set utf8");   
   $param['dbcharacter'] = 'utf8';      
}  

?>