<?php
// $Id: logmaker.inc.php 5 2008-12-12 05:55:19Z adgar $

function logfile_checkfilesize($filename) {
    $filepath = SCRIPT_REALPATH . DIRECTORY_SEPARATOR . LOG_FOLDER . DIRECTORY_SEPARATOR;
    $i=0; 
    while(true) {
        $file = $filepath  . $filename . '_' . $i . '.log';
        //max logfile size = 10Mb
        if (!file_exists($file) || (filesize($file) <= 10485760)) break;
        $i++;
    } 
    return $file;
}

function logfile_writeln($filename, $str='') {  
    $return = false;
    $logfile = logfile_checkfilesize($filename);
    $fpo = @fopen($logfile, 'a');
    if ($fpo) {
        fwrite($fpo, "$str\n");
        @fclose($stream);
        $return = true;
    }
    return $return;
}

function logfile_writefullinfo($filename) {   
    global $param;
    $return = false;
    $logfile = logfile_checkfilesize($filename);
    $fpo = @fopen($logfile, 'a');
    if ($fpo) {
        //hedder
        fwrite($fpo, "******************************\n");
        //date
        fwrite($fpo, 'DATETIME: ' . date("Y.d.m H:i:s") . "\n");
        //filename
        fwrite($fpo, 'FILENAME: ' . $param['selfname'] . "\n");
        //server
        fwrite($fpo, 'SERVER VARIABLES:' . "\n");
        fwrite($fpo, var_export($_SERVER, true) . "\n");
        //post
        fwrite($fpo, 'POST VARIABLES:' . "\n");
        fwrite($fpo, var_export($_POST, true) . "\n");
           
        //get
        fwrite($fpo, 'GET VARIABLES:' . "\n");
        fwrite($fpo, var_export($_GET, true) . "\n");
            
        //FILES
        fwrite($fpo, 'FILES VARIABLES:' . "\n");
        fwrite($fpo, var_export($_FILES, true) . "\n");
        
        //SESSION
        fwrite($fpo, 'SESSION VARIABLES:' . "\n");
        fwrite($fpo, var_export($_SESSION, true) . "\n");
        
        //COOKIE
        fwrite($fpo, 'COOKIE VARIABLES:' . "\n");
        fwrite($fpo, var_export($_COOKIE, true) . "\n");
        
        //footer
        fwrite($fpo, "******************************\n");
        @fclose ($fpo);    
        $return = true;    
    }
    return $return;    
}

if (defined('LOG_GENERAL')) {
    logfile_writefullinfo('general-log');
}

?>