<?php
// $Id: translator.inc.php 5 2008-12-12 05:55:19Z adgar $

require_once ('XML/Parser/Simple.php');

class TranslationPackageUpdater extends XML_Parser_Simple {
    var $col_number = 0;
    var $row_number = 0;    
    var $start_row = 1;
    var $col_interval = 2;   
    var $lng_alpha2 = '';
    var $content = array();
    //    
    var $sql_tr = '';
    var $cnt_tr = 0;    
    var $countries;    
    var $sql_cntr = '';
    var $cnt_cntr = 0;    
                    
    function TranslationPackageUpdater() {
        $this->XML_Parser_Simple();   
        $this->setMode('func');   
    }
    
    function run($lng_alpha2) {
        global $db, $param;
        $this->lng_alpha2 = $lng_alpha2;
        $this->countries = $db->getAssoc("SELECT ccode, cinterval, cname, cnumber FROM $param[dbprefix]countries WHERE lang_id=?", false, array(PRIMARY_LANGUAGE), DB_FETCHMODE_ASSOC, false);       
        $this->parse();     
        if (0 != $this->cnt_tr) {
            $this->sql_tr = "REPLACE INTO $param[dbprefix]translation (word_code, lng_alpha2, translate_text) VALUES " . rtrim($this->sql_tr, ',');
            $db->query($this->sql_tr);
        }
        if (0 != $this->cnt_cntr) {
            $this->sql_cntr = "REPLACE INTO $param[dbprefix]countries (cinterval, ccode, cname, cnumber, lang_id) VALUES " . rtrim($this->sql_cntr, ',');
            $db->query($this->sql_cntr);  
        }
    }

    function handleElement_Row($name, $attribs, $data) {
        global $param;
		$j =& $this->row_number;
       	$i =&  $this->col_number;  		
    	if ($j >= $this->start_row) {
            $pattern = "/^COUNTRY_([\w]{2})$/i";
            if ('utf8' == $param['dbcharacter']) $pattern .= 'u';         
            if (preg_match($pattern, $this->content[0], $match)) {
                $cid =& $match[1];               
                $this->sql_cntr .= "({$this->countries[$cid]['cinterval']}, '{$cid}', '{$this->content[1]}', {$this->countries[$cid]['cnumber']}, '{$this->lng_alpha2}'),";               
                $this->cnt_cntr++;                
            } else {                
                $this->sql_tr .= "('{$this->content[0]}','{$this->lng_alpha2}','{$this->content[1]}'),";            
                $this->cnt_tr++;    	               
            }
		}
		$this->content = array_fill(0, $this->col_interval , '');
    	$i=0; 		
    	$j++;		
    }
    
    function handleElement_Data($name, $attribs, $data) {    	
       	$i =&  $this->col_number;  
		if ($i < $this->col_interval) {
       		$this->content[$i] = addslashes($data);
       		$i++;
		}
    }    
   
}

function importTranslateExcelFile($path_to_file, $lng_alpha2) {
    $tpu = new TranslationPackageUpdater();
    $result = $tpu->setInputFile($path_to_file);
    if (!$tpu->isError($result)) {
        $tpu->run($lng_alpha2);      
    }	 
	return true;
}

function getDataFromTranslation($lng_alpha2) {
    global $param, $db;
    $tt1 = $db->getAssoc("SELECT CONCAT('COUNTRY_', ccode), cname FROM $param[dbprefix]countries WHERE lang_id=? ORDER BY cnumber", false, array($lng_alpha2), DB_FETCHMODE_ORDERED);    
    $tt2 = $db->getAssoc("SELECT word_code, translate_text FROM $param[dbprefix]translation WHERE lng_alpha2=? AND word_code NOT LIKE 'ERROR_%' ORDER BY word_code", false, array($lng_alpha2), DB_FETCHMODE_ORDERED);
    $tt3 = $db->getAssoc("SELECT word_code, translate_text FROM $param[dbprefix]translation WHERE lng_alpha2=? AND word_code LIKE 'ERROR_%' ORDER BY word_code", false, array($lng_alpha2), DB_FETCHMODE_ORDERED);
    $res = $tt1 + $tt2 + $tt3;
    return $res;
}

function getTranslationXMLFileContent($lng_alpha2, $selected = array()) {
    $data = getDataFromTranslation($lng_alpha2);
    $cnt = count($selected);
    $filtering = (0 != $cnt && count($data) != $cnt);
    $res = <<<HTML
<?xml version="1.0" encoding="UTF-8"?>
<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">
<Styles/>
<Worksheet ss:Name="{$lng_alpha2}">
<Table>
<Column ss:AutoFitWidth="1" ss:Hidden="0"/>
<Column ss:AutoFitWidth="1" ss:Hidden="0"/> 
   <Row>
    <Cell><Data ss:Type="String">Word Code</Data></Cell>
    <Cell><Data ss:Type="String">Translate Text</Data></Cell>
   </Row>
HTML;
    foreach ($data as $k => $v) {
        if ($filtering && !in_array($k, $selected)) continue;
		$res .= "
   <Row>
    <Cell><Data ss:Type=\"String\">" . $k . "</Data></Cell>
    <Cell><Data ss:Type=\"String\">" . htmlspecialchars($v, ENT_COMPAT, 'UTF-8') . "</Data></Cell>
   </Row>";   
    }

$res .= <<<HTML
</Table>
</Worksheet>
</Workbook>
HTML;
	return $res;
}


function deleteTextFromCurTranslation($keys, $lng_alpha2) {
	global $param, $db;      
    if (is_array($keys) && (count($keys) > 0)) {
        $sql = sql_placeholder("DELETE FROM $param[dbprefix]translation WHERE word_code in (?@) AND lng_alpha2=?", $keys, $lng_alpha2);
        $db->query($sql);    
    }
    return;
}

function addTextToTranslation($word_code, $translate_text, $lng_alpha2=null) {   
	global $param, $db;  
    $pattern = "/[^\w]/";
    if ('utf8' == $param['dbcharacter']) $pattern .= 'u';	
    $_word_code = preg_replace($pattern, '', $word_code);
	$_translate_text = stripslashes($translate_text);

	if (!empty($_word_code) && !empty($_translate_text)) {
        //generate 	language list    	    
        $lng_list = (!empty($lng_alpha2)) ? array($lng_alpha2) : $db->getCol("SELECT alpha2 FROM $param[dbprefix]languages WHERE (installed=1)");		        
        //country translate
        $pattern = "/^COUNTRY_([\w]{2})$/i";
        if ('utf8' == $param['dbcharacter']) $pattern .= 'u';
        if (preg_match($pattern, $_word_code, $match)) {
            for ($i=0, $max=count($lng_list); $i<$max; $i++) {
                $db->query("UPDATE $param[dbprefix]countries SET cname=? WHERE ccode=? AND lang_id=?", array($_translate_text, $match[1], $lng_list[$i]));
            }
        }
        //word translate
        else {        	    
    		for ($i=0, $max=count($lng_list); $i<$max; $i++) {
                $db->query("REPLACE INTO $param[dbprefix]translation (word_code, lng_alpha2, translate_text) VALUES (?, ?, ?)", array($_word_code, $lng_list[$i], $_translate_text));	
    		}
       }
	}	
    return;
}

            
function addLanguage($lng_alpha2) {
	global $param, $db;    
    //Add records in translation table
    if ($param['mysql_ver'] >= 4.1)
        $db->query("DROP TABLE IF EXISTS tempemp");
    $db->query("CREATE TEMPORARY TABLE tempemp SELECT word_code, ? as lng_alpha2, translate_text  FROM $param[dbprefix]translation WHERE lng_alpha2=?", array($lng_alpha2, DEFAULT_LANGUAGE));    
    $db->query("REPLACE INTO $param[dbprefix]translation SELECT * FROM tempemp");
    $db->query("DROP TABLE tempemp");        
    //Add records in countries table
    if ($param['mysql_ver'] >= 4.1)
        $db->query("DROP TABLE IF EXISTS tempemp");
    $db->query("CREATE TEMPORARY TABLE tempemp AS SELECT cinterval, ccode, cname, cnumber, ? FROM $param[dbprefix]countries WHERE lang_id=?", array($lng_alpha2, DEFAULT_LANGUAGE));    
    $db->query("INSERT INTO $param[dbprefix]countries (cinterval, ccode, cname, cnumber, lang_id) SELECT * FROM tempemp");
    $db->query("DROP TABLE tempemp");                
    //
    $db->query("UPDATE $param[dbprefix]languages SET installed=1, enable=0 WHERE alpha2=?", array($lng_alpha2));
    return;
}
        
function changeStatusLanguage($lng_alpha2) {
	global $param, $db;
    $db->query("UPDATE $param[dbprefix]languages SET enable = (IF(enable = 1, 0, 1)) WHERE (alpha2=?)", array($lng_alpha2));        
    return;
}

function removeLanguage($lng_alpha2) {
	global $param, $db;
    $db->query("UPDATE $param[dbprefix]languages SET installed=0, enable=0 WHERE (alpha2=?)", array($lng_alpha2));
    $db->query("DELETE FROM $param[dbprefix]translation WHERE (lng_alpha2=?)", array($lng_alpha2));	    
    $db->query("DELETE FROM $param[dbprefix]countries  WHERE (lang_id=?)", array($lng_alpha2));	    
    return;
}

function editLanguageDateFormat($lng_alpha2, $logn_dateformat, $short_dateformat) {
	global $param, $db;
    $db->query("UPDATE $param[dbprefix]languages SET long_date_format=?, short_date_format=? WHERE (alpha2=?)", array($logn_dateformat, $short_dateformat, $lng_alpha2));
    return;
}

?>