<?php
// $Id: AffPro.php 254 2008-04-02 11:52:58Z viktor $     

class AFFPRO 
{
    //public variables
        
    //private variables
    var $_version = '3.2';
    var $_dbversion = '2.023';
    var $_db;
    var $_param = '';
    
    //public function
    function AFFPRO(&$PEAR_BD, &$param) {
        if (is_a($PEAR_BD, 'DB_mysql')) $this->_db = $PEAR_BD;
        $this->_param = $param;    
        $this->_requestQuoteRemove();                
        //autoupdater
        $cdbver = $this->_db->getOne("SELECT value FROM config15 WHERE param='dbver'");
        $cdbver = sprintf('%.3f', $cdbver);
        if (version_compare($cdbver, $this->_dbversion, '<')) $this->_update($cdbver);
    }
    
    /**
    * @static
    */
    function isError($obj) {
        if (is_a($obj, 'AFFPRO_Error')) {
            return true;
        }
        return false;
    }
    
    /**
    * @static
    */
    function raiseError($twordcode = null, $code = null,  $mode = null,  $options = null) {
        $message = getTranslateText($twordcode);
        $ec = 'AFFPRO_Error';
        return new $ec(($message !== false) ? $message : null, $code,  $mode,  $options);
    }
    
    function initializeTranslateBuffer(&$buf_array) {
        $lang_id = getLanguageId();
        $buf_array = $this->_db->getAssoc("SELECT word_code, translate_text FROM {$this->_param['dbprefix']}translation WHERE lng_alpha2=? AND word_code NOT LIKE 'ERROR_%'", false, array($lang_id), DB_FETCHMODE_ASSOC);
    }
    
    function setCurrentLocale($locale_str) {
        $set_locale_params = split(' ', $locale_str);
        array_unshift($set_locale_params, LC_ALL|~LC_NUMERIC);
        $return = call_user_func_array('setlocale', $set_locale_params);
        return $return;    
    }
    
    /**
    * @static
    */            
    function redirect($url) {
        header("Location: $url");
        exit();
    }    
    
    /**
    * @static
    */
    function getResourcePath() {
        $path = SCRIPT_REALPATH . '/' . RESOURCE_FOLDER . '/';        
        $path = str_replace(array('/', '\\'), $path, DIRECTORY_SEPARATOR);
        return $path;
    }
    
    /**
    * @static
    */
    function getResourceUrl() {
        $url = HTTP_ADDR . RESOURCE_FOLDER . '/';
        $url = str_replace(array('/', '\\'), $url, '/');
        return $url;
    }
    
    /**
    * @static
    */           
    function getPHPConfgiErrors() {
        $phpconf_errors = array();
        if (version_compare(phpversion(), '4.3.0', '<')) {
            $phpconf_errors['php'] = 'ERROR_INCORRECT_PHP_VER';
        }
        if (!function_exists('mysql_connect')) {
            $phpconf_errors['mysql'] = 'ERROR_PHP_MYSQL_REQUIRED';
        }
        if (!extension_loaded('gd')) {
            $phpconf_errors['gd'] = 'ERROR_PHP_GD_REQUIRED';
        }
        if (function_exists('gd_info')) {
            $foo = gd_info();
            if (false == $foo['FreeType Support'] || strtolower($foo['FreeType Linkage']) != 'with freetype') {
                $phpconf_errors['ttf_support'] = 'ERROR_FREETYPE_REQUIRED';
            }
        } else {
            $phpconf_errors['ttf_support'] = 'ERROR_INCORRECT_PHP_GD_VER';
        }
/***        
        if (!function_exists('iconv')) {
            $phpconf_errors['iconv'] = 'ERROR_ICONV_REQUIRED';
        }
        if (!function_exists('mb_convert_case')) {
            $phpconf_errors['mbstring'] = 'ERROR_MBSTRING_REQUIRED';
        }
***/
        if (!function_exists('curl_init')) {
            $phpconf_errors['curl'] = 'ERROR_CURL_REQUIRED';
        }
        if (!extension_loaded('zlib')) {
            $phpconf_errors['zlib'] = 'ERROR_ZLIB_REQUIRED';
        }
        return $phpconf_errors;
    }
       
    function _requestQuoteRemove() {
        if (get_magic_quotes_gpc()) {
            stripslash_array($_GET);
            stripslash_array($_POST);
        }                
    }
        
    function _update($cdbver) {
        $respath =  AFFPRO::getResourcePath();
        $updpath =  $respath . 'autoaudate/autoaudate/';        
        $newdbver = sprintf('%.3f', floatval($cdbver) + .001);
        $sqlfile = $updpath . $newdbver . '.sql';        
        //unzip
        $zipfile = $respath .  'autoaudate/autoaudate.zip';        
        if (!file_exists($zipfile)) new AFFPRO_Error("File <em>$zipfile</em> not found", null,  AFFPRO_ERROR_DIE);
        require_once ('pclzip.lib.php');
        $zip = new PclZip($zipfile);
        $zip->extract(PCLZIP_OPT_PATH, $updpath, PCLZIP_OPT_BY_PREG, "/$newdbver\.sql\$/");
        //sql
        if (!file_exists($sqlfile)) new AFFPRO_Error("File <em>$sqlfile</em> not found", null,  AFFPRO_ERROR_DIE);
        $queries = (explode(';', file_get_contents($sqlfile)));
        foreach($queries as $query) {
            if (!($sql = trim($query))) continue;
            $sql = str_replace('[DB_PREFIX]', $this->_param['dbprefix'], $sql);
            $this->_db->query($sql);
        }
        //delete
        if (version_compare($newdbver, $this->_dbversion, '==')) {
            require_once('filesystem.inc.php');
            fs::delete($updpath);
        }      
        //redirect
        $this->redirect(HTTP_ADDR);
    }

}

define('AFFPRO_ERROR_RETURN',     1);
define('AFFPRO_ERROR_PRINT',      2);
define('AFFPRO_ERROR_DIE',        8);
define('AFFPRO_ERROR_CALLBACK',  16);

class AFFPRO_Error
{
    var $mode                 = AFFPRO_ERROR_RETURN;
    var $code                 = -1;
    var $message              = '';
    var $options              = '';

    function AFFPRO_Error($message = 'unknown error', $code = null, $mode = null, $options = null)
    {
        if ($mode === null)
        {
            $mode = AFFPRO_ERROR_RETURN;
        }

        $this->message   = $message;
        $this->code      = $code;
        $this->mode      = $mode;
        $this->options   = $options;


        if ($this->mode & AFFPRO_ERROR_PRINT)
        {
            if (is_null($this->$options) || is_int($this->$options))
            {
                $format = "%s";
            }
            else
            {
                $format = $this->$options;
            }
            printf($format, $this->getMessage());
        }


        if ($this->mode & AFFPRO_ERROR_DIE)
        {
            $msg = $this->getMessage();
            if (is_null($options) || is_int($options))
            {
                $format = "%s";
                if (substr($msg, -1) != "\n") {
                    $msg .= "\n";
                }
            } else {
                $format = $options;
            }
            die(sprintf($format, $msg));
        }

        if ($this->mode & AFFPRO_ERROR_CALLBACK)
        {
            if (is_string($this->options) && strlen($this->options))
            {
                call_user_func($this->options, $this);
            }
            else
            {
                if (is_array($this->options) &&
                    sizeof($this->options) == 2 &&
                    is_string($this->options[1]) &&
                    strlen($this->options[1]))
                {
                    call_user_func($this->options);
                }
            }
        }
    }


    function getMode() {
        return $this->mode;
    }


    function getCallback() {
        return $this->options;
    }


    function getMessage()
    {
        return $this->message;
    }


    function getCode()
    {
        return $this->code;
    }


    function getType()
    {
        return get_class($this);
    }


    function toString() {
        $modes = array();
        if ($this->mode & AFFPRO_ERROR_CALLBACK)
        {
            if (is_array($this->options))
            {
                $callback = $this->options[0] . '::' . $this->options[1];
            }
            else
            {
                $callback = $this->options;
            }
            return sprintf('[%s: message="%s" code=%d mode=callback callback=%s]',
                           get_class($this), $this->message, $this->code, $callback);
        }


        if ($this->mode & AFFPRO_ERROR_PRINT)
        {
            $modes[] = 'print';
        }


        if ($this->mode & AFFPRO_ERROR_DIE)
        {
            $modes[] = 'die';
        }


        if ($this->mode & AFFPRO_ERROR_RETURN)
        {
            $modes[] = 'return';
        }
        return sprintf('[%s: message="%s" code=%d mode=%s]',
                        get_class($this), $this->message, $this->code, implode("|", $modes));
    }
}


?>