<?php
class CSV {

// inner array,  in which we put all incoming data
var $csv_inner;
// outer string, which will contain csv-data
var $csv_outer;
// separator
var $separator;
// string delimiter 
var $str_delimiter;

  
function CSV($arr = array(), $settings = array()) {
	$this->csv_inner = (is_array($arr) ? $arr : ($arr ? array($arr) : array()));
	$this->csv_outer = "";
	$settings['separator'] = @$settigns['separator'] ? $settings['separator'] : ',';
	$settings['str_delimiter'] = @$settings['str_delimiter'] ? $settings['str_delimiter'] : "\n";
	
	$this->separator = $settings['separator'];
	$this->str_delimiter = $settings['str_delimiter'];
}


function send_headers($file_name = "", $headers = array()) {
	if (count($headers)) {
		for($t = 0; $t < count($headers); $t++) {
			header($headers[$t]);
		}
	}
	else {
		$file_name = $file_name ? $file_name : 'order.csv';

		header("Content-type: application/octet-stream;charset=utf8");
		header("Content-Disposition: attachment; filename=\"$file_name\"");
	}
}


function add($values) {
	if (!$values) {
		return;
	}
	$arr = is_array($values) ? $values : array($values);
	$this->csv_inner = array_merge($this->csv_inner, $arr);
}


function _create_csv_strings($arr) {
	$return = array();
	$return = "";
	$arr = is_array($arr) ? $arr : array($arr);
	$limit_char = "\"";
	foreach($arr as $key => $value) {
		if (is_array($value)) {
			$return[$key] .= $this->_create_csv_strings($value);
		}
		else {
			$pos = strpos($arr, "\"");
			$_value = $value;
			if ($pos) {
				$limit_char = "\"";
				$_value = str_replace("\"", "\"\"", $_value);
			}
			$pos = strpos($arr, $this->separator);
			if ($pos) {
				$limit_char = "\"";
			}
			if ($return) {
				$return .= $this->separator;
			}
			$return .= $limit_char.$_value.$limit_char;
		}
	}
	return $return;
}


function create_csv() {
	if (!count($this->csv_inner)) {
		return;
	}
	$foo_csv = $this->_create_csv_strings($this->csv_inner);
	$this->csv_outer = implode($this->str_delimiter, $foo_csv);
}


function show() {
	if (!$this->csv_outer) {
		$this->create_csv();
	}
	echo $this->csv_outer;
	
}
  
}
?>
