<?php
// $Id: FileCacher.class.php 5 2008-12-12 05:55:19Z adgar $

    class FileCacher {
        var $protocol = 'http';
        var $source_file = '';
        var $cache_folder = '';
        var $language = 'en';

        function FileCacher($cache_folder, $source_file='', $cache_live_time = 0) {
            $this->cache_folder = $cache_folder;
            $this->source_file = $source_file;
            if (isset($_COOKIE['lng_alpha2'])) {
                $this->language = $_COOKIE['lng_alpha2'];
            }
            if (isset($_SERVER['HTTPS']) && (1 == $_SERVER['HTTPS'] || 'on' == strtolower($_SERVER['HTTPS']))) {
                $this->protocol = 'https';
            }
            $this->cache_file = $this->cache_folder . DIRECTORY_SEPARATOR . md5($this->protocol . $this->source_file . $this->language);
            $res = false;
            if (file_exists($this->cache_file)) {
                $cur_time   = filemtime($this->source_file);
                $cache_time = filemtime($this->cache_file);

                if ($cur_time > $cache_time) $res = true;
                if ($cache_live_time != 0) {
                    if ((time() - $cache_time) > $cache_live_time) $res = true;
                }
            } else {
                $res = true;
            }

            if ($res) {
                ob_start();
            } else {
                echo file_get_contents($this->cache_file);
                exit();
            }
        }
        
        function end_caching() {
            $content = ob_get_contents();
            ob_end_clean();
            if (strlen($this->source_file) != 0) {
                $fcache = fopen($this->cache_file, 'w+');
                fwrite($fcache, $content);
                fclose($fcache);
            }
            echo $content;
            return;
        }

        function delete_cache($source_file = '') {
            if (empty($source_file)) {
                $file = basename($_SERVER['SCRIPT_FILENAME']);
                $cache_file = $this->cache_folder . DIRECTORY_SEPARATOR . md5($this->protocol . $file . $this->language); 
            } else {
                $cache_file = $this->cache_folder . DIRECTORY_SEPARATOR . md5($this->protocol . $source_file . $this->language); 
            }            
            if (file_exists($cache_file)) @unlink($cache_file);
        }
    }
    
?>