<?php
// $Id: FormChecker.class.php 10 2009-08-06 04:53:18Z adgar $  

class FormChecker
{
	//private properties
	var $in_buf		    = array();
	var $img_types		= array(1 => 'GIF', 'JPEG', 'PNG', 'SWF', 'PSD', 'BMP', 'TIFF_II', 'TIFF_MM', 'JPC', 'JP2', 'JPX', 'JB2', 'SWC', 'IFF', 'WBMP', 'XBM');
	var $actions		= array('CHECK_URL', 'CHECK_EMAIL', 'CHECK_NAME', 'CHECK_FILE', 'CHECK_GRAPHFILE', 'CHECK_COLOR', 'CHECK_NUMBER');
	var $patterns		= array('CHECK_URL'     => '/^https?:\/\/([-_a-z0-9&#\?\=\+%\/]+\.?)+\/?$/i', 
                                        'CHECK_EMAIL'   => '/^[-_\.a-z0-9]+@([-_a-z0-9]+\.?)*[a-z]{2,6}$/i',
                                        'CHECK_NAME'    => '/.+/',
                                        'CHECK_COLOR'   => '/^#[0-9a-fA-F]{6}$/',
                                        'CHECK_NUMBER'  => '/^\d+$/'
                                  );
	var $form_id		= 0;
	var $js_check		= false;
	//public properties

	//constructor
	function FormChecker($form_id = 'form1', $js_check = false)
	{
		$this->form_id	= $form_id;
		$this->js_check	= $js_check;
	}

	//public methods
	function addContent($name, $data, $action, $err_msg = null)
	{
		$numargs = func_num_args();
		if (($numargs >= 3)) {
			$result = TRUE;
			if ((!empty($name)) && (!isset($this->in_buf[$name])) && (in_array($action, $this->actions))) {
				if (empty($err_msg)) {
				
					switch ($action) {
					case 'CHECK_URL':        $err_msg = 'Invalid URL';         break;
					case 'CHECK_EMAIL':      $err_msg = 'Invalid EMAIL';       break;
					case 'CHECK_NAME':       $err_msg = 'Invalid NAME';        break;
					case 'CHECK_COLOR':      $err_msg = 'Invalid COLOR';       break;
					case 'CHECK_NUMBER':     $err_msg = 'Invalid NUMBER';      break;
					}
				}
				$this->in_buf[$name] = array('action' => $action, 'err_msg' => $err_msg, 'data' => $data);
				for ($i = 4; $i < $numargs; $i++) {
					$this->in_buf[$name]['param'.($i - 4)] = func_get_arg($i);
				}
			} else {
				if (isset($this->in_buf[$name])) {
					$result = AFFPro::raiseError('The element with this name alredy exist');
				} else {
					if (empty($name)) {
						$result = AFFPro::raiseError('Empty name');
					} else {
						if (in_array($type, $actions)) {
							$result = AFFPro::raiseError('Invalid action');
						}
					}
				}
			}
		}
		return $result;
	}

	//private:
    function check($value, $pattern, $err_msg) {
        $result = TRUE;
        if(!preg_match($pattern, $value)) {
            $result = AFFPro::raiseError($err_msg);
        }
        return $result;
    }

	//public: checking file
	function checkFile($value, $err_msg = null)
	{
		$result = TRUE;
		if (($value['error'] != 0) && (!(empty($value['name']) && ($value['size'] == 0)))) {
			if (empty($err_msg)) {
				switch($value['error']) {
				case 1:	$err_msg = "The uploaded file exceeds the upload_max_filesize directive in php.ini"; break;
				case 2:	$err_msg = "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form"; break;
				case 3:	$err_msg = "The uploaded file was only partially uploaded"; break;
				case 4:	$err_msg = "No file was uploaded"; break;
				case 5:	$err_msg = "Missing a temporary folder"; break;
				}
			}
			$result = AFFPro::raiseError($err_msg);
		}
		return $result;
	}

	//public: checking file
	function checkGraphFile($value, $err_msg = null, $ext = null)
	{
		$result = TRUE;
		for ($i = 0; $i < count($ext); $i++) {
			$ext[$i] = strtoupper($ext[$i]);
		}
		$res = $this->checkFile($value, $err_msg);
		if ((!AFFPro::isError($res)) && (!(empty($value['name']) && ($value['size'] == 0)))) {
			$res = getimagesize($value['tmp_name']);
			if ($res) {
				if ((!empty($ext)) && (is_array($ext))) {
					if (!in_array(strtoupper($this->img_types[$res[2]]), $ext)) {
						if (empty($err_msg)) $err_msg = 'Invalid format';
						$result = AFFPro::raiseError($err_msg);
					}
				}
			} else {
				if (empty($err_msg)) $err_msg = 'Invalid format';
				$result = AFFPro::raiseError($err_msg);
			}
		} else {
			$result = $res;
		}
		return $result;
	}

	//public: check buffer
	function checkContent()
	{
		$result		= true;
		$err_report	= array();
		foreach($this->in_buf as $name => $temp) {
			switch ($temp['action']) {
       			case 'CHECK_URL':
			case 'CHECK_EMAIL':
			case 'CHECK_NAME':
			case 'CHECK_COLOR':
			case 'CHECK_NUMBER':
				if (is_array($temp['data'])) {
					for ($i = 0; $i < count($temp['data']); $i++) {
						$res = $this->check($temp['data'][$i], $this->patterns[$temp['action']], $temp['err_msg']);
						if (AFFPro::isError($res)) $err_report[$name][$i] = $res->getMessage();
					}
				} else {
					$res = $this->check($temp['data'], $this->patterns[$temp['action']], $temp['err_msg']);
					if (AFFPro::isError($res)) $err_report[$name] = $res->getMessage();
				}
			break;
			case 'CHECK_FILE':
				if (is_array($temp['data']['name'])) {
					for ($i = 0; $i < count($temp['data']['name']); $i++) {
						foreach($temp['data'] as $k => $v) {
							$tmp_data[$k] = $v[$i];
						}
						$res = $this->checkFile($tmp_data, $temp['err_msg']);
						if (AFFPro::isError($res)) $err_report[$name][$i] = $res->getMessage();
					}
				} else {
					$res = $this->checkFile($temp['data'], $temp['err_msg']);
					if (AFFPro::isError($res)) $err_report[$name] = $res->getMessage();
				}
			break;
			case 'CHECK_GRAPHFILE':
				if (is_array($temp['data']['name'])) {
					for ($i = 0; $i < count($temp['data']['name']); $i++) {
						foreach($temp['data'] as $k => $v) {
							$tmp_data[$k] = $v[$i];
						}
						$res = $this->checkGraphFile($tmp_data, $temp['err_msg'], $temp['param0']);
					if (AFFPro::isError($res)) $err_report[$name][$i] = $res->getMessage();
				}
				} else {
					$res = $this->checkGraphFile($temp['data'], $temp['err_msg'], $temp['param0']);
					if (AFFPro::isError($res)) $err_report[$name] = $res->getMessage();
				}
			break;
			}
			if (AFFPro::isError($res)) $err_report[$name] = $res->getMessage();
		}
		if (!empty($err_report)) $result = $err_report;

		return $result;
	}

	//public: 
    function GetCheckingFunction()
    {
        
$result .= <<<HTML
<script type="text/javascript">
        function check_{$this->form_id}()
        {
        
HTML;
        if ($this->js_check == true) {
$result .= <<<HTML
         obj = new FormChecker("{$this->form_id}");
         
HTML;
            foreach($this->in_buf as $k => $v) {
                if (isset($this->patterns[$v['action']])) {
                    if (!is_array($v['data'])) {
$result .= "
         obj.addContent(\"{$k}\",\"{$v['action']}\",\"" . php2js($v['err_msg']) . "\");
         
";
                    }
                }
            }
$result .= <<<HTML
            var res = obj.checkContent();
            if (res == true) {
                return true;
            } else {
                alert(res);
                return false;
            }
HTML;
        } else {
$result .= <<<HTML
        return true;
HTML;
        }
$result .= <<<HTML
        }
</script>

HTML;
        return $result;
    }

    //public: generate body checking fucntion
    function GetCheckerClass()
    {
        
$result = <<<HTML
<script type="text/javascript">
    function FormChecker(formid)
    {
	    var form_id	= formid;
	    var in_buf	= new Array(0);
	    var debug	= true;
	    var max_row_num	= 5;
	    this.addContent = function(id, type, err_msg) {
		    if (err_msg.length == 0) {
			    switch(type) {
			    case 'CHECK_URL':	err_msg = "Invalid URL";	break;
			    case 'CHECK_NAME':	err_msg = "Invalid name";	break;
			    case 'CHECK_EMAIL':	err_msg = "Invalid Email";	break;
			    case 'CHECK_COLOR':	err_msg = "Invalid color";	break;
			    case 'CHECK_EMAIL':	err_msg = "Invalid number";	break;
			    }
		    }
		    in_buf[in_buf.length] = new Array(id, type, err_msg);
	    }
	    check = function(content, reg) {
			    if ((debug) && (content == null)) {
				    return null;
			    } else {
				    if (content.match(reg) == null) return false;
			    }
			    return true;
		    }
	    this.checkContent = function() {
		    var result = '';
		    var count = 0;
		    for (var i = 0; i < in_buf.length; i++) {
			    if (document.forms[form_id] == null) {
				    alert('Invalid form: ' + form_id);
			    } else {
				    var content = document.forms[form_id].elements[in_buf[i][0]].value;
				    switch(in_buf[i][1]) {
				    case 'CHECK_URL':	res = check(content, {$this->patterns['CHECK_URL']});	break;
				    case 'CHECK_NAME':	res = check(content, {$this->patterns['CHECK_NAME']});	break;
				    case 'CHECK_EMAIL':	res = check(content, {$this->patterns['CHECK_EMAIL']});	break;
				    case 'CHECK_COLOR':	res = check(content, {$this->patterns['CHECK_COLOR']});	break;
				    case 'CHECK_NUMBER':res = check(content, {$this->patterns['CHECK_NUMBER']});break;
				    }
				    if (res == null) {
					    alert(in_buf[i][0] + " - " + content);
				    } else {
					    if ((res == false) && (count <= (max_row_num - 1))) {
						    if (result.length != 0) result += "\\n";
						    result += " - " + in_buf[i][2];
						    count++;
					    }
				    }
			    }
		    }
		    if (result.length == 0) result = true;
		    return result;
	    }
    }
</script>

HTML;
        return $result;
    }
}
?>