<?php
// $Id: Reporter.class.php 5 2008-12-12 05:55:19Z adgar $

class Reporter {
    //headers
    var $headers=array();   
    //for print
    var $rows_tlp=array();
    var $rows_tlp_cnt = 0;
    //sort indexes
    var $row_key_indexs = array();                
    //pager
    var $pager_data = array();    
    //sql filter  
    var $sql_filter = '';    
    //resource
    var $resource = array();
    //ignore cols
    var $print_ignore = array();
    var $excel_ignore = array();           
    //norecord text    
    var $norecords_txt = 'No records';
    //name, description    
    var $reportname;      
    var $description_wordcode='';
    
    
    function Reporter($reportfile, $sql_filter='', $pager_enable=true) {
        global $db, $param;
        $this->reportname = basename($reportfile);
        $this->sql_filter = $sql_filter;        
        $fullpath_tp_reportfile = REPORT_REPOSITORY . DIRECTORY_SEPARATOR . $this->reportname;
        if (file_exists($fullpath_tp_reportfile))
            include_once($fullpath_tp_reportfile); 
        
        return;
    }
    
//static function    
    function base64_encode_special($string) {
    	$return = base64_encode($string);
		$encode_from = array("+", "/", "=");
    	$encode_to = array(".", "-", "_");
    	$return = str_replace($encode_from, $encode_to, $return);
    	                                        
    	return $return;
	}
	
//static function 
	function base64_decode_special($string) {
    	$string = urldecode($string);

    	$encode_from = array(".", "-", "_");
    	$encode_to = array("+", "/", "=");
    	$return = str_replace($encode_from, $encode_to, $string);

    	$return = base64_decode($return);
    	
    	return $return;
	}    
    
    function addColHeader($header='', $align='left', $tail=null, $index=null) {
        if (is_integer($index)) {        
           $this->headers[$index] = array($header, $align, $tail);
        } else {
            $this->headers[] = array($header, $align, $tail);
        }
        return;
    }
    
    function addResource($resname, &$res) {
        $this->resource[$resname] = $res;
        return;
    }    
    
    
    function addCellTemplate($tpl, $defvalue='&nbsp;', $index=null) {
        if (is_integer($index)) {
            $this->rows_tlp[$index] = array($tpl, $defvalue);
        } else {
            $this->rows_tlp[] = array($tpl, $defvalue);
        }
        return;
    }     
    
    function numRows() {
        return $this->rows_tlp_cnt;
    }
        
    function numCols() {
        $cnt = count($this->headers);
        return $cnt;
    }
        
    function setNorecordText($txt) {
        if (!empty($txt)) {
            $this->norecords_txt = $txt;
        }
        return;
    }
    
    function getNorecordText() {
        return $this->norecords_txt;
    }
        
    
    function setPrintIgnoreCols() {
        if (0 < func_num_args()) {
            $this->print_ignore = func_get_args();
        }
        return;
    }
    
    function setExcelIgnoreCols() {
        if (0 < func_num_args()) {
            $this->excel_ignore = func_get_args();
        }
        return;
    }
    
    function getPrintIgnoreCols() {
        return $this->print_ignore;
    }
    
    function getExcelIgnoreCols() {        
        return $this->excel_ignore;
    }    
    
    function getHeaders() {     
        return $this->headers;
    
    }   
    
   function getRowKeyIndexs() {            
        if (0 == count($this->row_key_indexs))
            $return = range(0, $this->rows_tlp_cnt - 1);            
        else 
            $return = $this->row_key_indexs;

        return $return; 
   }
        
    function getDescription($lng_alpha2=null) {
        $return = (empty($lng_alpha2)) ? getTranslateText($this->description_wordcode) : getTranslateText($this->description_wordcode, $lng_alpha2);
        return $return;
    }

    function sortIndexs($arr1, $param1='SORT_NUMERIC', $param2='SORT_DESC') {        
        if (is_array($arr1) && (0!= count($arr1))) {
            $key_indexs = range(0, $this->numRows() - 1);
            array_multisort($arr1, $param1, $param2, $key_indexs);
            $this->row_key_indexs = (count($this->pager_data) > 0) ? array_slice($key_indexs, $this->pager_data['start'], $this->pager_data['in_page']) : $key_indexs;
        }
        return;   
    }    
    
    function getCellText($colNumber=-1, $rowNumber=-1) {        
        global $param;
        $return = '&nbsp';
        if (isset($this->rows_tlp[$colNumber])) {
            $patterns = array();
            $replacements = array();
            $row_tpl = $this->rows_tlp[$colNumber];
            $return = (!empty($row_tpl[0])) ? $row_tpl[0] : $row_tpl[1]; 
            if (0 <  preg_match_all("/%(fn.*::)?(\w+)::\[(\w+)\]%/i", $return, $matches, PREG_SET_ORDER)) {
                for ($i=0, $max=count($matches); $i<$max; $i++) {                
                    $resource_key = $matches[$i][2];
                    $row_key = $matches[$i][3]; 
                    if (!empty($matches[$i][1])) {
                        preg_match("/fn\((\w+),?(.*)?\)::/i", $matches[$i][1], $fn_matches);
                        $fn_name = $fn_matches[1];
                        $fn_arg = explode(',', $fn_matches[2]);
                    }
                    $td_result = $this->getResourceParamByName($resource_key, $row_key, $rowNumber);
                    switch ($fn_name) {
                        case 'short_date_format': 
                            $td_result = strftime($param['short_date_format'], strtotime($td_result));
                        break;
                        //
                        case 'long_date_format': 
                            $td_result = strftime($param['long_date_format'], strtotime($td_result));
                        break;
                        //
                        case 'timeonly_date_format': 
                            $td_result = strftime('%H:%M', strtotime($td_result));
                        break;                                                
                        //
                        case 'reslink':
                            $td_result = $this->getResourceParamByName($fn_arg[0], $td_result, null, false);
                        break;                     
                        //
                        case 'longstr_crop':
                            if (0 == strlen($td_result)) {
                                $td_result = getTranslateText('UNKNOWN');
                            } else {
                                $td_result = substr($td_result, 0, intval($fn_arg[0])) . '...';
                            }
                        break;
                        //
                        case 'moneytextformat':
                            if (!empty($fn_arg[0]))  {  
                                   $cur_id = $this->getResourceParamByName($resource_key, $fn_arg[0], $rowNumber);
                                   $td_result = moneytextformat($td_result, $cur_id);
                                } else {
                                    $td_result = moneytextformat($td_result, 0, true);                          
                                }
                        break;
                        //
                        case 'moneytextfconvert':
//temporary						
						$def_currency = "";
						if (!$def_currency) {
    						$def_currency = getParamByName('def_join_currency');
						} 
//temporary						
                           $cur_id = $this->getResourceParamByName($resource_key, $fn_arg[0], $rowNumber);
                           $td_result = moneyConvert($td_result, $cur_id, $def_currency);
                           $td_result = moneytextformat($td_result, $def_currency);
                        break;                        
                        //
                        case 'currencytextformat':
                        $td_result = getCurrencyTextType($td_result, (bool) $fn_arg[0]);
                        break;  
                        //
                        case 'transactiontextformat':
                        //$td_result = getTransactionTextType($td_result);
                        //BEGIN TEMPORARY CODE
                         if (!empty($fn_arg[0]))  {
                             $is_recurring = $this->getResourceParamByName($resource_key, $fn_arg[0], $rowNumber);
                             global $transaction_types;
                             $td_result = getTransactionTextType($is_recurring == 1 ? $transaction_types['credit_recurring'] : $td_result);
                        } else {
                            $td_result = getTransactionTextType($td_result);
                        }                        
                        //END TEMPORARY CODE
                        break;  
                        //
                        case 'approvedlink':
                            global $yes_no_select_list;
                            $td_result = (1 == $td_result) ? $yes_no_select_list[1] : "<a href=\"$fn_arg[0]\">$yes_no_select_list[0]</a>";
                        break;  
                        //
                        case 'chargeback_filter':
                            global $transaction_types, $yes_no_select_list;
                            $cur_txn_type = $this->getResourceParamByName($resource_key, $fn_arg[0], $rowNumber);                            
                            $chargeback_id  = $this->getResourceParamByName($resource_key, 'chargeback_id', $rowNumber);
                            if ($cur_txn_type == $transaction_types['credit_primary']) {
                                //yes
                                if (!empty($chargeback_id)) {
                                    $return = "<a href=\"transaction_info.php?txn_id=$chargeback_id\" target=\"_blank\">" . getTranslateText('TT_YES') . "</a>";
                                }
                            } else {                                
                                $return = '-';
                                if(($cur_txn_type == $transaction_types['credit_secondary']) && (!empty($chargeback_id)))$return = "<a href=\"transaction_info.php?txn_id=$chargeback_id\" target=\"_blank\">" . getTranslateText('ALREADY_ISSUED') . "</a>";
                            }
                        break;  
                        //                      
                    }
                    
                    $patterns[] = "/%(fn\($fn_matches[1],?$fn_matches[2]?\)::)?$resource_key::\[$row_key\]%/i";
                    $replacements[] = preg_quote($td_result);
                }
                $foo = preg_replace($patterns, $replacements, $return);
                $return = stripslashes($foo);
            }
        }
        return $return;
    }
    
    function getResourceParamByName($resName, $paramName, $recordNumber=-1, $is_object=true) {
        $return = '';
        $res = $this->resource[$resName];       
        if ($is_object) {
            if ($recordNumber >= 0)  {
                $row = $res->fetchRow(DB_FETCHMODE_ASSOC, $recordNumber);
                $return = $row[$paramName];
            }
        } else {
            $return = $res[$paramName];
        }

        return $return;
    }
    
    function toHtml($exportpanel = true, $file_name = '2excel.php', $reportname = "", $sql_filter = "") {
		$reportname = $reportname ? $reportname : $this->reportname;
		$sql_filter = $sql_filter ? $sql_filter : $this->sql_filter;
		        
        $html = '';
        $max_str_lenght = 60;
        if (0 == $this->numRows()) {
            $html .= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" class=\"report\"><tr><td align=\"center\" class=\"row1\"><br /><br />" . $this->norecords_txt . "<br /><br /></td></tr></table>";            
        } else {
            //report tables param
            $col_cnt = $this->numCols();
            $row_cnt = $this->numRows(); 
            $row_key_indexs = $this->getRowKeyIndexs();
            //export
            if ($exportpanel) {
                $report_url = HTTP_ADDR . REPORTS_FOLDER . '/';
//                $report_url_tail = "?r=" . Reporter::base64_encode_special($this->reportname) . "&amp;f=" . Reporter::base64_encode_special($this->sql_filter);
                $report_url_tail_export = "?r=" . Reporter::base64_encode_special($reportname) . "&amp;f=" . Reporter::base64_encode_special($sql_filter);
                $report_url_tail_print = "?r=" . Reporter::base64_encode_special($this->reportname) . "&amp;f=" . Reporter::base64_encode_special($sql_filter);
                
                $html .= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td align=\"right\">";
                $html .= "
    <a href=\"{$report_url}{$file_name}".$report_url_tail_export."\" title=\"" . getTranslateText('TT_EXPORT_TO_EXCEL') . "\"><img src=\"../templates/images/data2xls.gif\" border=\"0\" alt=\"" . getTranslateText('TT_EXPORT_TO_EXCEL') . "\"></a>            
    &nbsp;
    <a href=\"{$report_url}print.php".$report_url_tail_print."\" target=_blank title=\"" . getTranslateText('TT_VIEW_PRINTABLE_VER') . "\"><img src=\"../templates/images/printer.gif\" border=\"0\" alt=\"" . getTranslateText('TT_VIEW_PRINTABLE_VER') . "\"></a>            
                ";
                $html .= "</td></tr></table>";              
            }
            //
            $html .= "<table border=\"0\" cellpadding=\"3\" cellspacing=\"0\" width=\"100%\" class=\"report\">";            
            //report header
            $html .= "<tr class=\"listheader\">";        
            for ($i=0; $i<$col_cnt; $i++) {
                $header = $this->headers[$i];
                $html .= "<td ";
                if (!empty($header[1])) {
                    $html .= "class=\"dir_$header[1]\" ";
                }
                $html .= (!empty($header[2])) ? $header[2] : '';
                $html .= ">" . ((!empty($header[0])) ?  " $header[0]" : '&nbsp;') . "</td>";
            }
            $html .= "</tr>";
            $index=0;            
            foreach($row_key_indexs as $tmp => $row_key_index) {
                $r = (($row_key_index)%2==0)?'1':'2';                 
                $html .= "<tr class=\"row$r\">";               
                for ($j=0; $j<$col_cnt; $j++) {
                    $cellText = $this->getCellText($j, $row_key_index); 
                    $cellText_strip_tags = strip_tags($cellText);
                    $html .= "<td ";
                    if (!empty($this->headers[$j][1])) {
                        $html .= "class=\"dir_{$this->headers[$j][1]}\" ";
                    } 
                    $html .= "nowrap>" . (('' != $cellText_strip_tags ) ? $cellText : '&nbsp;') . "</td>";                
                }   
                $html .= "</tr>"; 
                $index++;
            }
          
            $html .= "</table>";
            //pager
            if ($this->pager_data['all'] > $this->pager_data['in_page']) {
                $pagerHtmlCode =  getPagerHtmlCode($this->pager_data['all'], $this->pager_data['in_page'], null, true);        
                $html .= "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"pager\"><tr><td>" . getTranslateText('TT_PAGES') . ": $pagerHtmlCode</td></tr></table>";
            }
        }
        return $html;
    }
    
}
?>