<?php
//$Id$

class GeoIP_Wrapper {
  //private
  var $peclGeoIP = false;
  var $gi = null;

  function __construct() {
    $this->GeoIP_Wrapper();
  }

  function GeoIP_Wrapper() {
    $this->peclGeoIP = extension_loaded('geoip');
    if (!$this->peclGeoIP) {
      include_once('GeoIP/geoip.inc');
      define('GEOIP_DB', dirname(__FILE__).'/GeoIP/GeoIP.dat');
      $this->gi = geoip_open(GEOIP_DB, GEOIP_STANDARD);
    }
  }

  function country_code_by_addr($ip) {
    return ($this->peclGeoIP ? geoip_country_code_by_name($ip) : geoip_country_code_by_addr($this->gi, $ip));
  }

  function country_name_by_addr($ip) {
    return ($this->peclGeoIP ? geoip_country_name_by_name($ip) : geoip_country_name_by_addr($this->gi, $ip));
  }

}

?>