<?php
// $Id: 2excel.php 5 2008-12-12 05:55:19Z adgar $
require_once('reportcfg.php');
require_once('Writer.php');

$cur_report = new Reporter($reportpath, $sql_q, false);
//x,y
$row_cnt = $cur_report->numRows();
$col_cnt = $cur_report->numCols();
//headers
$headers = $cur_report->getHeaders();
strip_tags_array($headers);
//ignore
$ignore = $cur_report->getExcelIgnoreCols();
//sort index
$row_key_indexs = $cur_report->getRowKeyIndexs();
//description
$description = $cur_report->getDescription();
$description1 = $cur_report->getDescription(PRIMARY_LANGUAGE);

//excel filename
$pattern = "/[^\w]/";
if ('utf8' == $param['dbcharacter']) $pattern .= 'u';
$export_filename = preg_replace($pattern, "", $description1) . '.xls';

// Creating a workbook
$workbook = new Spreadsheet_Excel_Writer();
$workbook->setVersion(8);

// sending HTTP headers
$workbook->send($export_filename);

// set colors
$workbook->setCustomColor(10, 238, 238, 238);

// Creating a worksheet
$worksheet =& $workbook->addWorksheet($description1);
if ('utf8' == $param['dbcharacter']) $worksheet->setInputEncoding('UTF-8');

$format_header_description =& $workbook->addFormat();
$format_header_description->setBold();
$format_header_description->setAlign('vcenter');
$format_header_description->setAlign('left');
$format_header_description->setSize(16);

$format_header_left =& $workbook->addFormat();
$format_header_left->setBold();
$format_header_left->setAlign('top');
$format_header_left->setAlign('left');
$format_header_left->setTextWrap();
$format_header_left->setBorder(1);
$format_header_left->setFgColor(10);

$format_header_center =& $workbook->addFormat();
$format_header_center->setBold();
$format_header_center->setAlign('top');
$format_header_center->setAlign('center');
$format_header_center->setTextWrap();
$format_header_center->setBorder(1);
$format_header_center->setFgColor(10);

$format_header_right =& $workbook->addFormat();
$format_header_right->setBold();
$format_header_right->setAlign('top');
$format_header_right->setAlign('right');
$format_header_right->setTextWrap();
$format_header_right->setBorder(1);
$format_header_right->setFgColor(10);

$format_cell_left =& $workbook->addFormat();
$format_cell_left->setAlign('top');
$format_cell_left->setAlign('left');
$format_cell_left->setTextWrap();
$format_cell_left->setBorder(1);

$format_cell_center =& $workbook->addFormat();
$format_cell_center->setAlign('top');
$format_cell_center->setAlign('center');
$format_cell_center->setTextWrap();
$format_cell_center->setBorder(1);

$format_cell_right =& $workbook->addFormat();
$format_cell_right->setAlign('top');
$format_cell_right->setAlign('right');
$format_cell_right->setTextWrap();
$format_cell_right->setBorder(1);

$row_number = 0;

// header
$worksheet->write($row_number++, 0, getTranslateText('PERORT_HEADER1') . ': ' . $description, $format_header_description);
$worksheet->setRow(1, 30);

$ignore_cnt = 0;
for ($i=0; $i<$col_cnt; $i++) {
    if (false !== array_search($i+1, $ignore)) {
        $ignore_cnt++;        
        continue;  
    }    
    $k = $i - $ignore_cnt;  
    $format_header = 'format_header_' . $headers[$i][1];
    $worksheet->write($row_number, $k, $headers[$i][0], $$format_header);
    $worksheet->setColumn(0, $k, 30);
}
$row_number++;

foreach($row_key_indexs as $tmp => $row_key_index) {      
    $ignore_cnt = 0;    
    for ($j=0; $j<$col_cnt; $j++) {
        if (false !== array_search($j+1, $ignore)) {
            $ignore_cnt++;        
            continue;  
        }
        $k = $j - $ignore_cnt;        
        $format_cell = 'format_cell_' . $headers[$j][1];
        $celltext = strip_tags($cur_report->getCellText($j, $row_key_index));
        $celltext = str_replace('&nbsp;', ' ', $celltext);
        $worksheet->write($row_number, $k, $celltext, $$format_cell);
    }
    $row_number++;

}
// Let's send the file
$workbook->close();
//
?>