<?php
// $Id: adm_aff_stats.rep.php 11 2009-08-06 04:53:31Z adgar $

checkAccess('A');

/**
 * Add SQL resource
 */
global $transaction_types, $users_types, $base1, $selfname;

$rs = $db->query("SELECT t2.id, t2.name, t2.reg_time FROM $param[dbprefix]users as t2 WHERE t2.usertype=? AND t2.approved=1 $sql_filter", array($users_types['affiliater']));

if ($pager_enable) {
    $records = array('in_page'=>PAGER_PER_PAGE);
    $records['start'] = (isset($_REQUEST['entrant']) && (intval($_REQUEST['entrant']) > 0)) ? ((int)$_REQUEST['entrant'] - 1)*$records['in_page'] : 0;
    $records['all'] = $rs->numRows();
    $this->pager_data = $records;
}

$sum_sales_multicurrency = $db->getAssoc("SELECT t1.user_id, sum(t1.amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE t1.approved=1 AND t1.txn_type IN (?, ?) GROUP BY t1.user_id, t1.orig_cur_index", false, array($transaction_types['credit_primary'], $transaction_types['debit_chargeback']), DB_FETCHMODE_ASSOC, true);
$sum_sales = array();
$top_data = array();    

$arr1=array();
while ($users_row = $rs->fetchRow(DB_FETCHMODE_ASSOC) ) {   
    $key_one = $users_row['id'];    
        //convert to default cyrrency
        $sum_sales[$key_one] = 0;
        if (isset($sum_sales_multicurrency[$key_one])) {
            $transactions =& $sum_sales_multicurrency[$key_one];
            for($k=0, $max=count($transactions); $k<$max; $k++) {
                $sum_sales[$key_one] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
            }
        } 
        $top_data[$key_one] = moneytextformat($sum_sales[$key_one], DEFAULT_JOIN_CURRENCY);   
        //sort data
        $arr1[] = $sum_sales[$key_one];         
}

arsort($top_data);

$this->addResource('rs', $rs);
$this->addResource('top_data', $top_data);

$this->rows_tlp_cnt = $rs->numRows();
$this->sortIndexs($arr1, SORT_NUMERIC, SORT_DESC);

/**
 * Add Report Headers
 */
$currency = getCurrencyTextType(DEFAULT_JOIN_CURRENCY);
$currency_text = (!empty($currency['cur_symbol'])) ? $currency['cur_symbol'] : $currency['cur_alpha3'];
$this->addColHeader(getTranslateText('REP_H_USERNAME'), 'left', "width=\"50%\" nowrap=\"nowrap\""); //1
$this->addColHeader(getTranslateText('TT_REGISTERED'), 'left', "width=\"25%\" nowrap=\"nowrap\""); //2
$this->addColHeader(getTranslateText('TT_SUM_SUMBOL') . getTranslateText('TT_FLAT_SALES'), 'right', "width=\"25%\" nowrap=\"nowrap\""); //3


/**
 * Add row template
 */
$this->addCellTemplate("<a href=\"details.php?id=%rs::[id]%\" target=\"_blank\">%rs::[name]%</a>"); //1
$this->addCellTemplate("%fn(long_date_format)::rs::[reg_time]%"); //2
$this->addCellTemplate("%fn(reslink,top_data)::rs::[id]%"); //3

/**
 * Add ignor lists
 */

//$this->setPrintIgnoreCols(9);
//$this->setExcelIgnoreCols(9);

/**
 * Add text description
 */
$this->description_wordcode = getTranslateText('TT_AFF_STATS');
$this->setNorecordText(getTranslateText('TT_NOTEXT11'));

?>