<?php
// $Id: adm_aff_stats_csv.rep.php 5 2008-12-12 05:55:19Z adgar $

checkAccess('A');

/**
 * Add SQL resource
 */
global $transaction_types, $users_types, $base1, $selfname;

$rs = $db->query("SELECT t2.id, t2.name, t2.reg_time FROM $param[dbprefix]users as t2 WHERE t2.usertype=? AND t2.approved=1 $sql_q", array($users_types['affiliater']));

$def_currency = getParamByName('def_join_currency');
$currency = getCurrencyTextType($def_currency);
$currency_text = (!empty($currency['cur_symbol'])) ? $currency['cur_symbol'] : $currency['cur_alpha3'];

$sum_sales_multicurrency = $db->getAssoc("SELECT t1.user_id, sum(t1.amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE t1.approved=1 AND t1.txn_type IN (?, ?) GROUP BY t1.user_id, t1.orig_cur_index", false, array($transaction_types['credit_primary'], $transaction_types['debit_chargeback']), DB_FETCHMODE_ASSOC, true);

$sum_sales = array();
$top_data = array();    

$arr1=array();
while ($users_row = $rs->fetchRow(DB_FETCHMODE_ASSOC) ) {   
    $key_one = $users_row['id'];    
        //convert to default cyrrency
        $sum_sales[$key_one] = 0;
        if (isset($sum_sales_multicurrency[$key_one])) {
            $transactions =& $sum_sales_multicurrency[$key_one];
            for($k=0, $max=count($transactions); $k<$max; $k++) {
                $sum_sales[$key_one] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], $def_currency);
            }
        } 
        $top_data[$key_one] = moneytextformat($sum_sales[$key_one], $def_currency);   
        //sort data
        $arr1[] = $sum_sales[$key_one];         
}

arsort($top_data);

$foo_csv = new CSV();
$caption = array(
0 => array(getTranslateText('TT_AFF_STATS')), 
1 => array(
	getTranslateText('REP_H_USERNAME'),
	getTranslateText('TT_REGISTERED'),
	getTranslateText('TT_SUM_SUMBOL').getTranslateText('TT_FLAT_SALES')
	)
);

$foo_csv->send_headers('affiliate_stats.csv');
$foo_csv->add($caption);

$rs = $db->getAll("SELECT t2.id, t2.name, t2.reg_time FROM $param[dbprefix]users as t2 WHERE t2.usertype=? AND t2.approved=1 $sql_q", array($users_types['affiliater']));


for($t = 0; $t < count($rs); $t++) {
	
	$csv_string = array(
	0 => array(
		$rs[$t]['name'], 
		$rs[$t]['reg_time'], 
		$top_data[$rs[$t]['id']]
		)
	);
	$foo_csv->add($csv_string);
}
$foo_csv->show();


?>