<?php
// $Id: adm_payout_history_csv.rep.php 5 2008-12-12 05:55:19Z adgar $

require_once('AffPro/CSV.class.php');
require_once('types.inc.php');
require_once('currency.inc.php');

global $transaction_types;

$foo_history = $db->getAll("SELECT t1.*, t2.name as username, t2.usertype FROM $param[dbprefix]transactions as t1 INNER JOIN $param[dbprefix]users as t2 ON t1.user_id=t2.id WHERE txn_type=? $sql_filter ORDER BY t1.create_date DESC", array($transaction_types['debit_payout']));        


$foo_csv = new CSV();
$foo_csv->send_headers('payout_history.csv');

$captions = array(
0 => array(getTranslateText(38)), 
1 => array(
	getTranslateText('REP_H_ID'),
	getTranslateText('REP_H_AMOUNT'),
	getTranslateText('REP_H_DATE'),
	getTranslateText('REP_H_TIME'),
	getTranslateText('REP_H_USERNAME'),
	)
);

$foo_csv->add($captions);


for($t = 0; $t < count($foo_history); $t++) {
	$csv_string = array(
	0 => array(
		$foo_history[$t]['txn_id'], 
		moneytextformat($foo_history[$t]['amount'], $foo_history[$t]['orig_cur_index']), 
		date("Y-m-d", strtotime($foo_history[$t]['create_date'])), 
		date("G:h", strtotime($foo_history[$t]['create_date'])), 
		$foo_history[$t]['username']
		)
	);
	$foo_csv->add($csv_string);
}

$foo_csv->show();
?>
