<?php
// $Id: adm_ppc_stats.rep.php 11 2009-08-06 04:53:31Z adgar $

checkAccess('A');

/**
 * Add SQL resource
 */
global $transaction_types, $users_types, $base1, $selfname;

$rs = $db->query("SELECT t2.id, t2.name FROM $param[dbprefix]users as t2 WHERE t2.usertype=? AND t2.approved=1 $sql_filter", array($users_types['affiliater']));        

if ($pager_enable) {
    $records = array('in_page'=>PAGER_PER_PAGE);
    $records['start'] = (isset($_REQUEST['entrant']) && (intval($_REQUEST['entrant']) > 0)) ? ((int)$_REQUEST['entrant'] - 1)*$records['in_page'] : 0;
    $records['all'] = $rs->numRows();
    $this->pager_data = $records;
}

$sum_click = $db->getAssoc("SELECT user_id, sum(clickcount) as param FROM $param[dbprefix]traffic GROUP BY user_id ORDER BY user_id", false, null, DB_FETCHMODE_ORDERED);   
$sum_sales_multicurrency = $db->getAssoc("SELECT t1.user_id, sum(t1.amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE t1.approved=1 AND t1.txn_type IN (?, ?) GROUP BY t1.user_id, t1.orig_cur_index", false, array($transaction_types['credit_primary'], $transaction_types['debit_chargeback']), DB_FETCHMODE_ASSOC, true);
$sum_click_print = array();
$sum_sales = array();
$top_data = array();    

$arr1=array();
while ($users_row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {   
    $key_one = $users_row['id'];
    $key_two = $users_row['name'];    
    //calculate ppc
    if (isset($sum_click[$key_one])) {
        //convert to default cyrrency
        if (isset($sum_sales_multicurrency[$key_one])) {
            $transactions =& $sum_sales_multicurrency[$key_one];
            for($k=0, $max=count($transactions); $k<$max; $k++) {
                $sum_sales[$key_one] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
            }
        }    
        //ppc
        $sum_click_print[$key_one] = $sum_click[$key_one];
        $top_data[$key_one] = sprintf("%.2f", $sum_sales[$key_one] / $sum_click[$key_one]);
        $sum_sales[$key_one] = moneytextformat($sum_sales[$key_one], DEFAULT_JOIN_CURRENCY);
    } 
    //set zero ppc    
    else {
        $sum_click_print[$key_one] = 0;
        $top_data[$key_one] = sprintf("%.2f", 0);
        $sum_sales[$key_one] = moneytextformat(0, DEFAULT_JOIN_CURRENCY);        
    }
    //sort data
    $arr1[] = $top_data[$key_one]; 
}

$this->addResource('rs', $rs);
$this->addResource('sum_sales', $sum_sales);
$this->addResource('sum_click_print', $sum_click_print);
$this->addResource('top_data', $top_data);

$this->rows_tlp_cnt = $rs->numRows();
$this->sortIndexs($arr1, SORT_NUMERIC, SORT_DESC);



/**
 * Add Report Headers
 */
$currency = getCurrencyTextType(DEFAULT_JOIN_CURRENCY);
$currency_text = (!empty($currency['cur_symbol'])) ? $currency['cur_symbol'] : $currency['cur_alpha3'];
$this->addColHeader(getTranslateText('REP_H_USERNAME'), 'left', "width=\"25%\" nowrap=\"nowrap\""); //1
$this->addColHeader(getTranslateText('TT_SUM_SUMBOL') . $currency_text, 'right', "width=\"25%\" nowrap=\"nowrap\""); //2
$this->addColHeader(getTranslateText('TT_SUM_SUMBOL') . getTranslateText('TT_CLICK'), 'right', "width=\"25%\" nowrap=\"nowrap\""); //3
$this->addColHeader(getTranslateText('TT_PPC'), 'right', "width=\"25%\" nowrap=\"nowrap\""); //4



/**
 * Add row template
 */
$this->addCellTemplate("<a href=\"details.php?id=%rs::[id]%\" target=\"_blank\">%rs::[name]%</a>"); //1
$this->addCellTemplate("%fn(reslink,sum_sales)::rs::[id]%"); //2
$this->addCellTemplate("%fn(reslink,sum_click_print)::rs::[id]%"); //3
$this->addCellTemplate("%fn(reslink,top_data)::rs::[id]%"); //4
/**
 * Add ignor lists
 */

//$this->setPrintIgnoreCols(9);
//$this->setExcelIgnoreCols(9);

/**
 * Add text description
 */
$this->description_wordcode = getTranslateText('TT_PROFIT_PER_CLICK');
$this->setNorecordText(getTranslateText('TT_NOTEXT11'));

?>