<?php
// $Id: adm_ppc_stats_csv.rep.php 5 2008-12-12 05:55:19Z adgar $

require_once('AffPro/CSV.class.php');
require_once('types.inc.php');
require_once('currency.inc.php');

global $transaction_types, $users_types, $base1, $selfname;


$foo_csv = new CSV();
$foo_csv->send_headers('ppc_stats.csv');

$rs = $db->query("SELECT t2.id, t2.name FROM $param[dbprefix]users as t2 WHERE t2.usertype=? AND t2.approved=1 $sql_q", array($users_types['affiliater']));        


$sum_click = $db->getAssoc("SELECT user_id, sum(clickcount) as param FROM $param[dbprefix]traffic GROUP BY user_id ORDER BY user_id", false, null, DB_FETCHMODE_ORDERED);   
$sum_sales_multicurrency = $db->getAssoc("SELECT t1.user_id, sum(t1.amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE t1.approved=1 AND t1.txn_type IN (?, ?) GROUP BY t1.user_id, t1.orig_cur_index", false, array($transaction_types['credit_primary'], $transaction_types['debit_chargeback']), DB_FETCHMODE_ASSOC, true);
$sum_click_print = array();
$sum_sales = array();
$top_data = array();    

$arr1=array();
while ($users_row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {   
    $key_one = $users_row['id'];
    $key_two = $users_row['name'];    
    //calculate ppc
    if (isset($sum_click[$key_one])) {
        //convert to default cyrrency
        if (isset($sum_sales_multicurrency[$key_one])) {
            $transactions =& $sum_sales_multicurrency[$key_one];
            for($k=0, $max=count($transactions); $k<$max; $k++) {
                $sum_sales[$key_one] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
            }
        }    
        //ppc
        $sum_click_print[$key_one] = $sum_click[$key_one];
        $top_data[$key_one] = sprintf("%.2f", $sum_sales[$key_one] / $sum_click[$key_one]);
        $sum_sales[$key_one] = moneytextformat($sum_sales[$key_one], DEFAULT_JOIN_CURRENCY);
    } 
    //set zero ppc    
    else {
        $sum_click_print[$key_one] = 0;
        $top_data[$key_one] = sprintf("%.2f", 0);
        $sum_sales[$key_one] = moneytextformat(0, DEFAULT_JOIN_CURRENCY);        
    }
    //sort data
    $arr1[] = $top_data[$key_one]; 
}

$def_currency = getParambyName('def_join_currency');
$currency = getCurrencyTextType($def_currency);
$currency_text = (!empty($currency['cur_symbol'])) ? $currency['cur_symbol'] : $currency['cur_alpha3'];

$captions = array(
0 => array(getTranslateText('TT_PROFIT_PER_CLICK')), 
1 => array(getTranslateText('REP_H_USERNAME'), 
getTranslateText('TT_SUM_SUMBOL') . $currency_text,
getTranslateText('TT_SUM_SUMBOL') . getTranslateText('TT_CLICK'),
getTranslateText('TT_PPC'))
);
$foo_csv->add($captions);

$rs = $db->getAll("SELECT t2.id, t2.name FROM $param[dbprefix]users as t2 WHERE t2.usertype=? AND t2.approved=1 $sql_q", array($users_types['affiliater']));        

for($t = 0; $t < count($rs); $t++) {
	$csv_string = array(
	$rs[$t]['name'], 
	moneytextformat($sum_sales[$rs[$t]['id']], $def_currency), 
	$sum_click_print[$rs[$t]['id']], 
	$top_data[$rs[$t]['id']]
	);
	$foo_csv->add(array($csv_string));
}
$foo_csv->show();

?>