<?php
// $Id: adm_product_stats.rep.php 11 2009-08-06 04:53:31Z adgar $

checkAccess('A');

/**
 * Add SQL resource
 */
global $transaction_types, $users_types, $base1, $selfname;

$rs = $db->query("SELECT t2.group_id, t2.name FROM $param[dbprefix]groups as t2 WHERE (1=1) $sql_filter");

$year=date('Y');      
$month=date('m');
$startdate = array(
    'last_1year' => date('Y-m-d H:i:s', mktime(0, 0, 0, $month, 1, $year-1)),
    'last_3month' => date('Y-m-d H:i:s', mktime(0, 0, 0, $month-3, 1, $year)),
    'last_1month' => date('Y-m-d H:i:s', mktime(0, 0, 0, $month-1, 1, $year)),
); 

$sum_sales_multicurrency1 = $db->getAssoc("SELECT t1.product_id, txn_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['credit_primary'], $startdate['last_1year']), DB_FETCHMODE_ASSOC, true);
$sum_chargeback_multicurrency1 = $db->getAssoc("SELECT key_one, t1.product_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['debit_chargeback'], $startdate['last_1year']), DB_FETCHMODE_ASSOC, true);

$sum_sales_multicurrency2 = $db->getAssoc("SELECT t1.product_id, txn_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['credit_primary'], $startdate['last_3month']), DB_FETCHMODE_ASSOC, true);
$sum_chargeback_multicurrency2 = $db->getAssoc("SELECT key_one, t1.product_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['debit_chargeback'], $startdate['last_3month']), DB_FETCHMODE_ASSOC, true);

$sum_sales_multicurrency3 = $db->getAssoc("SELECT t1.product_id, txn_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['credit_primary'], $startdate['last_1month']), DB_FETCHMODE_ASSOC, true);
$sum_chargeback_multicurrency3 = $db->getAssoc("SELECT key_one, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['debit_chargeback'], $startdate['last_1month']), DB_FETCHMODE_ASSOC, true);

$top_data1 = $top_data2 = $top_data3 = array();

while ($product_row = $rs->fetchRow(DB_FETCHMODE_ASSOC) ) {          
    $key_one = $product_row['group_id'];
    
    $top_data1[$key_one] = $top_data2[$key_one] =  $top_data3[$key_one] = 0;
    //last year
    if (isset($sum_sales_multicurrency1[$key_one])) {
        $product_sales =& $sum_sales_multicurrency1[$key_one];
        for($k=0, $max=count($product_sales); $k<$max; $k++) {
            //sales
            $top_data1[$key_one] += moneyConvert($product_sales[$k]['amount'], $product_sales[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
            //chargeback
            $chargeback_key_one = $product_sales[$k]['txn_id'];
            if (isset($sum_chargeback_multicurrency1[$chargeback_key_one])) {
                $chargeback =& $sum_chargeback_multicurrency1[$chargeback_key_one][0];
                $top_data1[$key_one] += moneyConvert($chargeback['amount'], $chargeback['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
            }            
        }
    }
    //last 3 month
    if (isset($sum_sales_multicurrency2[$key_one])) {
        $product_sales =& $sum_sales_multicurrency2[$key_one];        
        for($k=0, $max=count($product_sales); $k<$max; $k++) {
            //sales
            $top_data2[$key_one] += moneyConvert($product_sales[$k]['amount'], $product_sales[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
            //chargeback
            $chargeback_key_one = $product_sales[$k]['txn_id'];
            if (isset($sum_chargeback_multicurrency2[$chargeback_key_one])) {
                $chargeback =& $sum_chargeback_multicurrency2[$chargeback_key_one][0];
                $top_data2[$key_one] += moneyConvert($chargeback['amount'], $chargeback['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
            }            
        }
    }
    //last 1 month
    if (isset($sum_sales_multicurrency3[$key_one])) {
        $product_sales =& $sum_sales_multicurrency3[$key_one];
        for($k=0, $max=count($product_sales); $k<$max; $k++) {
            //sales
            $top_data3[$key_one] += moneyConvert($product_sales[$k]['amount'], $product_sales[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
            //chargeback
            $chargeback_key_one = $product_sales[$k]['txn_id'];
            if (isset($sum_chargeback_multicurrency3[$chargeback_key_one])) {
                $chargeback =& $sum_chargeback_multicurrency3[$chargeback_key_one][0];
                $top_data3[$key_one] += moneyConvert($chargeback['amount'], $chargeback['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
            }
        }
    }
        
}

$arr1 = $cur_product_keys = array();
foreach ($top_data1 as $k => $v) {        
    if ($v > 0)  {
        $cur_product_keys[] = $k;
        $arr1[] =  $v;            
    }
    $top_data1[$k] = moneytextformat($top_data1[$k], DEFAULT_JOIN_CURRENCY);
    if (isset($top_data2[$k]))
        $top_data2[$k] = moneytextformat($top_data2[$k], DEFAULT_JOIN_CURRENCY);
    if (isset($top_data3[$k]))
        $top_data3[$k] = moneytextformat($top_data3[$k], DEFAULT_JOIN_CURRENCY);
}

if (count($cur_product_keys) != 0)  {
    $cur_product_keys_str = implode(', ', $cur_product_keys);
    $rs_notnull = $db->query("SELECT t2.group_id, t2.name FROM $param[dbprefix]groups as t2 WHERE t2.group_id IN ($cur_product_keys_str) $sql_filter");
} else {
    $rs_notnull = $db->query("SELECT 1 LIMIT 0");    
}

if ($pager_enable) {
    $records = array('in_page'=>PAGER_PER_PAGE);
    $records['start'] = (isset($_REQUEST['entrant']) && (intval($_REQUEST['entrant']) > 0)) ? ((int)$_REQUEST['entrant'] - 1)*$records['in_page'] : 0;   
    $records['all'] = $rs_notnull->numRows();
    $this->pager_data = $records;
}

$this->addResource('rs_notnull', $rs_notnull);
$this->addResource('top_data1', $top_data1);
$this->addResource('top_data2', $top_data2);
$this->addResource('top_data3', $top_data3);

$this->rows_tlp_cnt = $rs_notnull->numRows();
$this->sortIndexs($arr1, SORT_NUMERIC, SORT_DESC);

/**
 * Add Report Headers
 */
$this->addColHeader(getTranslateText('TT_PRODUCT_GROUP'), 'left', "width=\"40%\" nowrap=\"nowrap\""); //1
$this->addColHeader(getTranslateText('TT_LAST_YEAR'), 'right', "width=\"20%\" nowrap=\"nowrap\""); //2
$this->addColHeader(getTranslateText('TT_LAST_3MOUNTH'), 'right', "width=\"20%\" nowrap=\"nowrap\""); //3
$this->addColHeader(getTranslateText('TT_LAST_1MOUNTH'), 'right', "width=\"20%\" nowrap=\"nowrap\""); //4



/**
 * Add row template
 */
$this->addCellTemplate("<a href=\"gr_edit.php#%rs_notnull::[group_id]%\" target=\"_blank\">%rs_notnull::[name]%</a>"); //1
$this->addCellTemplate("%fn(reslink,top_data1)::rs_notnull::[group_id]%"); //2
$this->addCellTemplate("%fn(reslink,top_data2)::rs_notnull::[group_id]%"); //3
$this->addCellTemplate("%fn(reslink,top_data3)::rs_notnull::[group_id]%"); //4
/**
 * Add ignor lists
 */

//$this->setPrintIgnoreCols(9);
//$this->setExcelIgnoreCols(9);

/**
 * Add text description
 */
$this->description_wordcode = getTranslateText('TT_PRODUCT_STATS');
$this->setNorecordText(getTranslateText('TT_NOTEXT11'));

?>