<?php
// $Id: adm_product_stats_csv.rep.php 5 2008-12-12 05:55:19Z adgar $

checkAccess('A');

/**
 * Add SQL resource
 */
global $transaction_types, $users_types, $base1, $selfname;

$rs = $db->query("SELECT t2.group_id, t2.name FROM $param[dbprefix]groups as t2 WHERE (1=1) $sql_q");

$def_currency = getParamByName('def_join_currency');

$year=date('Y');      
$month=date('m');
$startdate = array(
    'last_1year' => date('Y-m-d H:i:s', mktime(0, 0, 0, $month, 1, $year-1)),
    'last_3month' => date('Y-m-d H:i:s', mktime(0, 0, 0, $month-3, 1, $year)),
    'last_1month' => date('Y-m-d H:i:s', mktime(0, 0, 0, $month-1, 1, $year)),
); 

$sum_sales_multicurrency1 = $db->getAssoc("SELECT t1.product_id, txn_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['credit_primary'], $startdate['last_1year']), DB_FETCHMODE_ASSOC, true);
$sum_chargeback_multicurrency1 = $db->getAssoc("SELECT key_one, t1.product_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['debit_chargeback'], $startdate['last_1year']), DB_FETCHMODE_ASSOC, true);

$sum_sales_multicurrency2 = $db->getAssoc("SELECT t1.product_id, txn_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['credit_primary'], $startdate['last_3month']), DB_FETCHMODE_ASSOC, true);
$sum_chargeback_multicurrency2 = $db->getAssoc("SELECT key_one, t1.product_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['debit_chargeback'], $startdate['last_3month']), DB_FETCHMODE_ASSOC, true);

$sum_sales_multicurrency3 = $db->getAssoc("SELECT t1.product_id, txn_id, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['credit_primary'], $startdate['last_1month']), DB_FETCHMODE_ASSOC, true);
$sum_chargeback_multicurrency3 = $db->getAssoc("SELECT key_one, t1.orig_amount as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.txn_type=?) AND (t1.create_date > ?)", false, array($transaction_types['debit_chargeback'], $startdate['last_1month']), DB_FETCHMODE_ASSOC, true);

$top_data1 = $top_data2 = $top_data3 = array();


while ($product_row = $rs->fetchRow(DB_FETCHMODE_ASSOC) ) {          
    $key_one = $product_row['group_id'];
    
    $top_data1[$key_one] = $top_data2[$key_one] =  $top_data3[$key_one] = 0;
    //last year
    if (isset($sum_sales_multicurrency1[$key_one])) {
        $product_sales =& $sum_sales_multicurrency1[$key_one];
        for($k=0, $max=count($product_sales); $k<$max; $k++) {
            //sales
            $top_data1[$key_one] += moneyConvert($product_sales[$k]['amount'], $product_sales[$k]['orig_cur_index'], $def_currency);
            //chargeback
            $chargeback_key_one = $product_sales[$k]['txn_id'];
            if (isset($sum_chargeback_multicurrency1[$chargeback_key_one])) {
                $chargeback =& $sum_chargeback_multicurrency1[$chargeback_key_one][0];
                $top_data1[$key_one] += moneyConvert($chargeback['amount'], $chargeback['orig_cur_index'], $def_currency);
            }            
        }
    }
    //last 3 month
    if (isset($sum_sales_multicurrency2[$key_one])) {
        $product_sales =& $sum_sales_multicurrency2[$key_one];        
        for($k=0, $max=count($product_sales); $k<$max; $k++) {
            //sales
            $top_data2[$key_one] += moneyConvert($product_sales[$k]['amount'], $product_sales[$k]['orig_cur_index'], $def_currency);
            //chargeback
            $chargeback_key_one = $product_sales[$k]['txn_id'];
            if (isset($sum_chargeback_multicurrency2[$chargeback_key_one])) {
                $chargeback =& $sum_chargeback_multicurrency2[$chargeback_key_one][0];
                $top_data2[$key_one] += moneyConvert($chargeback['amount'], $chargeback['orig_cur_index'], $def_currency);
            }            
        }
    }
    //last 1 month
    if (isset($sum_sales_multicurrency3[$key_one])) {
        $product_sales =& $sum_sales_multicurrency3[$key_one];
        for($k=0, $max=count($product_sales); $k<$max; $k++) {
            //sales
            $top_data3[$key_one] += moneyConvert($product_sales[$k]['amount'], $product_sales[$k]['orig_cur_index'], $def_currency);
            //chargeback
            $chargeback_key_one = $product_sales[$k]['txn_id'];
            if (isset($sum_chargeback_multicurrency3[$chargeback_key_one])) {
                $chargeback =& $sum_chargeback_multicurrency3[$chargeback_key_one][0];
                $top_data3[$key_one] += moneyConvert($chargeback['amount'], $chargeback['orig_cur_index'], $def_currency);
            }
        }
    }
        
}

$arr1 = $cur_product_keys = array();
foreach ($top_data1 as $k => $v) {        
    if ($v > 0)  {
        $cur_product_keys[] = $k;
        $arr1[] =  $v;            
    }
    $top_data1[$k] = moneytextformat($top_data1[$k], $def_currency);
    if (isset($top_data2[$k]))
        $top_data2[$k] = moneytextformat($top_data2[$k], $def_currency);
    if (isset($top_data3[$k]))
        $top_data3[$k] = moneytextformat($top_data3[$k], $def_currency);
}

if (count($cur_product_keys) != 0)  {
    $cur_product_keys_str = implode(', ', $cur_product_keys);
    $rs_notnull = $db->query("SELECT t2.group_id, t2.name FROM $param[dbprefix]groups as t2 WHERE t2.group_id IN ($cur_product_keys_str) $sql_q");
} else {
    $rs_notnull = $db->query("SELECT 1 LIMIT 0");    
}

$rs = $db->getAll("SELECT t2.group_id, t2.name FROM $param[dbprefix]groups as t2 WHERE (1=1) $sql_q");

$foo_csv = new CSV();
$foo_csv->send_headers('products_stats.csv');
$captions = array(
0 => array(getTranslateText('TT_PRODUCT_STATS')), 
1 => array(
	getTranslateText('TT_PRODUCT_GROUP'),
	getTranslateText('TT_LAST_YEAR'),
	getTranslateText('TT_LAST_3MOUNTH'),
	getTranslateText('TT_LAST_1MOUNTH')
	)
);

$foo_csv->add($captions);

for($t = 0; $t < count($rs); $t++) {
	$csv_string = array(
	0 => array(
		$rs[$t]['name'], 
		$top_data1[$rs[$t]['group_id']], 
		$top_data2[$rs[$t]['group_id']], 
		$top_data3[$rs[$t]['group_id']]
		)
	);
	$foo_csv->add($csv_string);
}


$foo_csv->show();

?>