<?php
require_once('AffPro/CSV.class.php');
require_once('types.inc.php');
require_once('currency.inc.php');

checkAccess('A');

global $transaction_types;

$foo_transactions = $db->getAll("SELECT t1.txn_id, t1.orig_cur_index, t1.txn_type, t1.amount, t1.create_date, t2.name, t1.approved FROM $param[dbprefix]transactions as t1 INNER JOIN $param[dbprefix]users as t2 ON t1.user_id=t2.id LEFT JOIN $param[dbprefix]transactions as t3 ON (t1.txn_id=t3.key_one AND t3.txn_type=?) WHERE t1.approved=1 $sql_q ORDER BY t1.txn_id DESC, txn_id", array($transaction_types['debit_chargeback']));

for($t = 0; $t < count($foo_transactions); $t++) {
	$foo = array();
	$foo['id'] = $foo_transactions[$t]['txn_id'];
	$foo['transaction_type'] = getTransactionTextType($foo_transactions[$t]['txn_type']);
	$foo['amount'] = moneytextformat($foo_transactions[$t]['amount'], $foo_transactions[$t]['orig_cur_index']);
	$foo_date = explode(" ", $foo_transactions[$t]['create_date']);
	$foo['date'] = date("m/d/Y", strtotime($foo_date[0]));
	$foo['time'] = $foo_date[1];
	$foo['username'] = $foo_transactions[$t]['name'];
	$foo['approved'] = getTranslateText('TT_YES');
	$foo_transactions[$t] = $foo;
}

$foo_csv = new CSV();
$foo_csv->send_headers('Transactions.csv');
$captions = array(
0 => array(
	getTranslateText(28)
), 
1 => array(
 	getTranslateText('REP_H_ID'), 
 	getTranslateText('REP_H_TXNTYPE'), 
 	getTranslateText('REP_H_AMOUNT'), 
 	getTranslateText('REP_H_DATE'), 
 	getTranslateText('REP_H_TIME'), 
 	getTranslateText('REP_H_USERNAME'), 
 	getTranslateText('REP_H_APPROVED')
	)
);
$foo_csv->add($captions);

if (!$foo_transactions || !count($foo_transactions)) {
	$foo_csv->add(array(
	getTranslateText('NORECORD_TXN'), 
	));
}
else {
	$foo_csv->add($foo_transactions);
}
$foo_csv->show();

?>