//------------------------------------------------------------------
// detect a special case of "web browser"
//------------------------------------------------------------------
is_ie = ( /msie/i.test(navigator.userAgent) &&
         !/opera/i.test(navigator.userAgent) );

//------------------------------------------------------------------
// detect Opera browser
//------------------------------------------------------------------
is_opera = /opera/i.test(navigator.userAgent);

//------------------------------------------------------------------
//
//------------------------------------------------------------------
function getAbsPosX(id) {
    var el = document.getElementById(id);
    var res = 0;
    do {
        res += el.offsetLeft;
    } while (typeof(el = el.offsetParent) != 'undefined' && el != null);
    return res;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function getAbsPosY(id) {
    var el = document.getElementById(id);
    var res = 0;
    do {
        res += el.offsetTop;
    } while (typeof(el = el.offsetParent) != 'undefined' && el != null);
    return res;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function rgb2hsv(r, g, b) {
    var h;
    var s;
    var v;
    var min = r;
    var max = r;

    if (g < min) min = g;
    if (b < min) min = b;
 
    if (g > max) max = g;
    if (b > max) max = b;
    v = 100 * max/255;
 
    var delta = max - min;
    if (!max) {
        s = 0;
    } else {
        s = 100 * delta/max;
    }
  
    if (!s) {
        h = 0;
    } else {
        if (r == max) {
            h = 60 * (g - b)/delta;
        } else if (g == max) {
            h = 120 + 60 * (b - r)/delta;
        } else if (b == max) {
            h = 240 + 60 * (r - g)/delta;
        }
        if (h < 0) h = h + 360;
    }
    hsv = new Array;
    hsv[0] = h/360;
    hsv[1] = s/100;
    hsv[2] = v/100;
    return hsv;
}


//------------------------------------------------------------------
// HSV conversion algorithm adapted from easyrgb.com
//------------------------------------------------------------------
function hsv2rgb(h, s, v) {
    var rgb = new Array;
    if (s == 0) {
        rgb[0] = v * 255;
        rgb[1] = v * 255;
        rgb[2] = v * 255;
    } else {
        var_h = h * 6;
        var_i = Math.floor(var_h);
        var_1 = v * (1 - s);
        var_2 = v * (1 - s * (var_h - var_i));
        var_3 = v * (1 - s * (1 - (var_h - var_i)));

        if (var_i == 0) {
            var_r = v;
            var_g = var_3;
            var_b = var_1
        } else if (var_i == 1) {
            var_r = var_2;
            var_g = v;
            var_b = var_1
        } else if (var_i == 2) {
            var_r = var_1;
            var_g = v;
            var_b = var_3
        } else if (var_i == 3) {
            var_r = var_1;
            var_g = var_2;
            var_b = v;
        } else if (var_i == 4) {
            var_r = var_3;
            var_g = var_1;
            var_b = v;
        } else {
            var_r = v;
            var_g = var_1;
            var_b = var_2
        }
        rgb[0] = Math.round(var_r * 255);
        rgb[1] = Math.round(var_g * 255);
        rgb[2] = Math.round(var_b * 255);
    }
    return rgb;
}


//------------------------------------------------------------------
// function returns hex color as strings
//------------------------------------------------------------------
function rgb2hex(rgb) {
    var hex = new String;
    for (var i = 0; i < 3; i++) {
        var tmp = parseInt(rgb[i]).toString(16);
        if (tmp.length < 2) {
            hex += "0" + tmp;
        } else {
            hex += tmp;
        }
    }

    return hex.toUpperCase();
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function hex2rgb(hex) {
    var rgb = new Array();
    var i, x = '0123456789ABCDEF', c='';
    hex = hex.toUpperCase();
    for (i = 0; i < 3; i++) {
        rgb[i] = 16 * x.indexOf(hex.charAt(2*i + 1)) + x.indexOf(hex.charAt(2*i + 2));
    }
    return rgb;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function hsv2hex(h, s, v) {
    var rgb = hsv2rgb(h, s, v);
    return rgb2hex(rgb);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function hex2hsv(hex) {
    var rgb = hex2rgb(hex);
    return rgb2hsv(rgb[0], rgb[1], rgb[2]);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox = function() {
    this.xOffs    = 0;
    this.yOffs    = 0;
    this.hue      = 1;
    this.sat      = 1;
    this.val      = 1;

    this.prefix   = "colorbox_";

    this.CaptureSV     = false;
    this.CaptureH      = false;
    this.CaptureWindow = false;
    this.id_text       = null;
    this.id_color      = null;

    this.relativeX     = 0;
    this.relativeY     = 0;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.addEvent = function(el, evname, func) {
    if (el.attachEvent) { // IE
        el.attachEvent("on" + evname, func);
    } else if (el.addEventListener) { // Gecko / W3C
        el.addEventListener(evname, func, true);
    } else {
        el["on" + evname] = func;
    }
};


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.stopEvent = function(ev) {
    ev || (ev = window.event);
/*    if (is_ie) {
        ev.cancelBubble = true;
        ev.returnValue = false;
    } else {
        ev.preventDefault();
        ev.stopPropagation();
    }*/
if(ev.stopPropagation) ev.stopPropagation();
else ev.cancelBubble = true;
if(ev.preventDefault) ev.preventDefault();
else ev.returnValue = false;
    return false;
};


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function onGradient(mouseX, mouseY) {
    var abs_X = getAbsPosX(window.colorbox.prefix + "gradient");
    var abs_Y = getAbsPosY(window.colorbox.prefix + "gradient");

    if (((mouseX >= abs_X) && (mouseX < (abs_X + 258))) && ((mouseY >= abs_Y) && (mouseY < (abs_Y + 258)))) {
        return true;
    }
    return false;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function onHue(mouseX, mouseY) {
    var abs_X = getAbsPosX(window.colorbox.prefix + "hue");
    var abs_Y = getAbsPosY(window.colorbox.prefix + "hue");

    if (((mouseX >= abs_X) && (mouseX < (abs_X + 21))) && ((mouseY >= abs_Y) && (mouseY < (abs_Y + 258)))) {
        return true;
    }

    return false;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function onTitle(mouseX, mouseY) {
    var abs_X = getAbsPosX(window.colorbox.prefix + "title_text");
    var abs_Y = getAbsPosY(window.colorbox.prefix + "title_text");

    if (((mouseX >= abs_X) && (mouseX < (abs_X + 449))) && ((mouseY >= abs_Y) && (mouseY < (abs_Y + 21)))) {
        return true;
    }

    return false;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function doMouseDown(e) {
    var x, y;
    if (document.layers) { //Netscape?
/**/        alert('INCOMPLETE!!!')
    } else if (document.all) {
        x = event.x + document.body.scrollLeft; 
        y = event.y + document.body.scrollTop; 
    } else if (document.getElementById) {
        x = e.pageX;
        y = e.pageY;
    }
    if (is_ie) {x -= 2; y -= 2;}

    if (onGradient(x, y)) {
        window.colorbox.CaptureSV = true;
        window.colorbox.SetSVPointer(x, y);
    } else if (onHue(x, y)) {
        window.colorbox.CaptureH = true;
        window.colorbox.SetHPointer(y);
    } else if (onTitle(x, y)) {
        window.colorbox.CaptureWindow = true;
        window.colorbox.xOffs = x - getAbsPosX(window.colorbox.prefix + "window");
        window.colorbox.yOffs = y - getAbsPosY(window.colorbox.prefix + "window");
    }
}



//------------------------------------------------------------------
//
//------------------------------------------------------------------
function doMouseMove(e) {
    var x, y;
    if (document.layers) { //Netscape?
/**/        alert('INCOMPLETE!!!')
    } else if (document.all) {
        x = event.x + document.body.scrollLeft; 
        y = event.y + document.body.scrollTop; 
    } else if (document.getElementById) {
        x = e.pageX;
        y = e.pageY;
    }
    if (is_ie) {x -= 2; y -= 2;}

    if (window.colorbox.CaptureSV) {
        window.colorbox.SetSVPointer(x, y);
    } else if (window.colorbox.CaptureH) {
        window.colorbox.SetHPointer(y);
    } else if (window.colorbox.CaptureWindow) {
           window.colorbox.SetPos(x - window.colorbox.xOffs, y - window.colorbox.yOffs);
    }

    return ColorBox.stopEvent(e);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function doMouseUp(e) {
    window.colorbox.CaptureSV     = false;
    window.colorbox.CaptureH      = false;
    window.colorbox.CaptureWindow = false;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function onPressHandler(ev) {
    ev || (ev = window.event);
    var key = (is_ie) ? ev.keyCode : ev.which;

    var id = (is_ie) ? ev.srcElement.id : ev.currentTarget.id;

    if ((key == 8) || (key == 0)) {
        return;
    }

    if ((id == (window.colorbox.prefix + "hue_text")) ||
        (id == (window.colorbox.prefix + "sat_text")) ||
        (id == (window.colorbox.prefix + "val_text")) ||
        (id == (window.colorbox.prefix + "r_text")) ||
        (id == (window.colorbox.prefix + "g_text")) ||
        (id == (window.colorbox.prefix + "b_text")))
    {
        if ((key >= 48) && (key <= 57))
        {
            return;
        }
    } else if (id == (window.colorbox.prefix + "hex_text")) {
        if ((((key >= 65) && (key <= 70))  ||
             ((key >= 97) && (key <= 102)) ||
             ((key >= 48) && (key <= 57))) &&
             (document.getElementById(id).value.length < 6))
        {
            return;
        }
    }
    ColorBox.stopEvent(ev);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function onUpHandler(ev) {
    ev || (ev = window.event);
    var id = (is_ie) ? ev.srcElement.id : ev.currentTarget.id;

    if (document.getElementById(id) != null) {
        value = document.getElementById(id).value;

        var hex;
        if (id == (window.colorbox.prefix + "hex_text")) {
            pattern = /^[0-9a-fA-F]{6}$/;
            res = value.match(pattern);
            if (res != null) {
               window.colorbox.SetCustomColor('#' + res);
            }
        } else if (id == (window.colorbox.prefix + "hue_text")) {
            window.colorbox.SetCustomColorHSV(value/360, window.colorbox.sat, window.colorbox.val);
        } else if (id == (window.colorbox.prefix + "sat_text")) {
            window.colorbox.SetCustomColorHSV(window.colorbox.hue, value/100, window.colorbox.val);
        } else if (id == (window.colorbox.prefix + "val_text")) {
            window.colorbox.SetCustomColorHSV(window.colorbox.hue, window.colorbox.sat, value/100);
        } else if (id == (window.colorbox.prefix + "r_text")) {
            var rgb = hsv2rgb(window.colorbox.hue, window.colorbox.sat, window.colorbox.val);
            rgb[0] = (value < 256) ? value : 255;
            var hsv = rgb2hsv(rgb[0], rgb[1], rgb[2]);
            window.colorbox.SetCustomColorHSV(hsv[0], hsv[1], hsv[2]);
        } else if (id == (window.colorbox.prefix + "g_text")) {
            var rgb = hsv2rgb(window.colorbox.hue, window.colorbox.sat, window.colorbox.val);
            rgb[1] = (value < 256) ? value : 255;
            var hsv = rgb2hsv(rgb[0], rgb[1], rgb[2]);
            window.colorbox.SetCustomColorHSV(hsv[0], hsv[1], hsv[2]);
        } else if (id == (window.colorbox.prefix + "b_text")) {
            var rgb = hsv2rgb(window.colorbox.hue, window.colorbox.sat, window.colorbox.val);
            rgb[2] = (value < 256) ? value : 255;
            var hsv = rgb2hsv(rgb[0], rgb[1], rgb[2]);
            window.colorbox.SetCustomColorHSV(hsv[0], hsv[1], hsv[2]);
        } else return;

        document.getElementById("text").value = hex;
    }
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.prototype.Init = function(hex) {
    tmp = new String;
    tmp += "<div class=\"colorbox\" id=\"" + this.prefix + "window\" style=\"left:0px; top:0px;\">\n";
    tmp += "<table class=\"colorbox_table\"><tr><td>\n";
    tmp += "<table class=\"title\">\n";
    tmp += "  <tr>\n";
    tmp += "     <td id=\"" + this.prefix + "title_text\"   class=\"title_text\">Color Picker</td>\n";
    tmp += "     <td id=\"" + this.prefix + "button_close\" class=\"close_button\">&#x00d7;</td>\n";
    tmp += "  </tr>\n";
    tmp += "</table>\n";
    tmp += "<table class=\"hsv\" id=\"" + this.prefix + "image_table\">";
    tmp += "  <tr>\n";
    tmp += "    <td>";
    tmp += "      <table style=\"height:100%; border-collapse:collapse;\">";
    tmp += "        <tr>";
    tmp += "          <td style=\"width:20px\"></td>";
    tmp += "          <td class=\"h\"  id=\"" + this.prefix + "hue\"/></td>";
    tmp += "          <td style=\"width:20px\"></td>";
    tmp += "        </tr>\n";
    tmp += "      </table>";
    tmp += "    </td>";
    tmp += "    <td class=\"sv\" id=\"" + this.prefix + "gradient\" style=\"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + AFFPRO_BaseURL + "templates/images/cbox/gradient.png', sizingMethod='scale')\"></td>";
    tmp += "    <td style=\"padding:0px\">";
    tmp += "      <table style=\"height:258px; border-collapse:collapse;\">";
    tmp += "        <tr style=\"height:163px;\">";
    tmp += "          <td>";
    tmp += "            <table class=\"additional\">";
    tmp += "              <tr style=\"height:68px\">";
    tmp += "                <td colspan=\"6\">";
    tmp += "                   <input type=\"text\" id=\"" + this.prefix + "color_preview\" class=\"preview\" disabled=\"disabled\" />";
    tmp += "                </td>";
    tmp += "              </tr>";
    tmp += "              <tr>";
    tmp += "                <td style=\"width:15px\">H:</td>";
    tmp += "                <td><input type=\"text\" id=\"" + this.prefix + "hue_text\" /></td>";
    tmp += "                <td style=\"width:15px\">&deg;</td>";
    tmp += "                <td style=\"width:15px\">&nbsp;</td>";
    tmp += "                <td style=\"width:15px\">R:</td>";
    tmp += "                <td><input type=\"text\" id=\"" + this.prefix + "r_text\" /></td>";
    tmp += "              </tr>";             
    tmp += "              <tr>";
    tmp += "                <td>S:</td>";
    tmp += "                <td><input type=\"text\" id=\"" + this.prefix + "sat_text\" /></td>";
    tmp += "                <td>%</td>";
    tmp += "                <td></td>";
    tmp += "                <td>G:</td>";
    tmp += "                <td><input type=\"text\" id=\"" + this.prefix + "g_text\" /></td>";
    tmp += "              </tr>";
    tmp += "              <tr>";
    tmp += "                <td>V:</td>";
    tmp += "                <td><input type=\"text\" id=\"" + this.prefix + "val_text\" /></td>";
    tmp += "                <td>%</td>";
    tmp += "                <td></td>";
    tmp += "                <td>B:</td>";
    tmp += "                <td><input type=\"text\" id=\"" + this.prefix + "b_text\" /></td>";
    tmp += "              </tr>";
    tmp += "              <tr>";
    tmp += "                <td>#</td>";
    tmp += "                <td colspan=\"5\"><input type=\"text\" class=\"hex\" id=\"" + this.prefix + "hex_text\" /></td>";
    tmp += "              </tr>";
    tmp += "            </table>";
    tmp += "          </td>";
    tmp += "        </tr>";
    tmp += "        <tr>";
    tmp += "          <td style=\"vertical-align: bottom; padding-bottom:10px;\">";
    tmp += "            <table style=\"border-collapse:collapse\" align=\"center\">";
    tmp += "              <tr>";
    tmp += "                <td><input type=\"button\" class=\"cb_button\" value=\"Ok\" id=\"" + this.prefix + "IDOK\"/></td>";
    tmp += "                <td style=\"width:5px\"></td>";
    tmp += "                <td><input type=\"button\" class=\"cb_button\" value=\"Cancel\" id=\"" + this.prefix + "IDCANCEL\"/></td>";
    tmp += "              </tr>";
    tmp += "            </table>";
    tmp += "          </td>";
    tmp += "        </tr>";
    tmp += "      </table>";   
    tmp += "    </td>";
    tmp += "  </tr>\n";
    tmp += "</table>\n";
    tmp += "</td></tr></table>\n";
    tmp += "</div>\n";
    tmp += "<div class=\"cur_pos_grad\" id=\"" + this.prefix + "cur_pos_grad\"  style=\"left:0px; top:0px;\"></div>\n";
    tmp += "<div class=\"cur_pos_hue\" id=\"" + this.prefix + "cur_pos_hue\"  style=\"left:0px; top:0px;\"></div>\n";
    document.body.innerHTML += tmp;

    ColorBox.addEvent(document, "mousemove", doMouseMove);
    ColorBox.addEvent(document, "mousedown", doMouseDown);
    ColorBox.addEvent(document, "mouseup"  , doMouseUp);
    ColorBox.addEvent(document.getElementById(this.prefix + "IDOK"), "click"         , ColorBox.onOk);
    ColorBox.addEvent(document.getElementById(this.prefix + "IDCANCEL"), "click"     , ColorBox.onClose);
    ColorBox.addEvent(document.getElementById(this.prefix + "button_close"), "click" , ColorBox.onClose);
    ColorBox.addEvent(document.getElementById(this.prefix + "hex_text"), "keypress"  , onPressHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "hue_text"), "keypress"  , onPressHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "sat_text"), "keypress"  , onPressHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "val_text"), "keypress"  , onPressHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "r_text")  , "keypress"  , onPressHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "g_text")  , "keypress"  , onPressHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "b_text")  , "keypress"  , onPressHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "hex_text"), "keyup"  , onUpHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "hue_text"), "keyup"  , onUpHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "sat_text"), "keyup"  , onUpHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "val_text"), "keyup"  , onUpHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "r_text"), "keyup"  , onUpHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "g_text"), "keyup"  , onUpHandler);
    ColorBox.addEvent(document.getElementById(this.prefix + "b_text"), "keyup"  , onUpHandler);
    st = document.getElementById(this.prefix + "cur_pos_grad").style;
    if (is_ie) {
        st.width  = "9px";
        st.height = "9px";
    } else {
        st.width  = "7px";
        st.height = "7px";
    }
    if (!is_ie) document.getElementById(this.prefix + "gradient").style.backgroundImage = "url('" + AFFPRO_BaseURL + "templates/images/cbox/gradient.png')";
    if (hex == null) hex = "#000000";
    this.SetCustomColor(hex);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.prototype.SetCustomColor = function(hex) {
    rgb = hex2rgb(hex);
    hsv = rgb2hsv(rgb[0], rgb[1], rgb[2]);
    this.SetCustomColorHSV(hsv[0], hsv[1], hsv[2]);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.prototype.SetCustomColorHSV = function(h, s, v) {
    this.hue = h;
    this.sat = s;
    this.val = v;
    var abs_X = getAbsPosX(window.colorbox.prefix + "gradient");
    var abs_Y = getAbsPosY(window.colorbox.prefix + "gradient");
    var x = this.sat * 257 + abs_X;
    var y = (1 - this.val) * 257 + abs_Y;
    this.SetSVPointer(x, y);

    abs_Y = getAbsPosY(window.colorbox.prefix + "hue");
    y = (1 - this.hue) * 257 + abs_Y;
    this.SetHPointer(y);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.prototype.SetTitleText = function(text) {
    document.getElementById(this.prefix + "title_text").innerHTML = text;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.prototype.SetPos = function(x, y) {
    var st;
    var dx = getAbsPosX(this.prefix + "cur_pos_grad") - getAbsPosX(this.prefix + "window");
    var dy = getAbsPosY(this.prefix + "cur_pos_grad") - getAbsPosY(this.prefix + "window");

    st = document.getElementById(this.prefix + "cur_pos_grad").style;
    st.left = (x + dx) + "px";
    st.top  = (y + dy) + "px";

    dx = getAbsPosX(this.prefix + "cur_pos_hue") - getAbsPosX(this.prefix + "window");
    dy = getAbsPosY(this.prefix + "cur_pos_hue") - getAbsPosY(this.prefix + "window");
    st = document.getElementById(this.prefix + "cur_pos_hue").style;
    st.left = (x + dx) + "px";
    st.top  = (y + dy) + "px";

    st = document.getElementById(this.prefix + "window").style;
    st.left = x + "px";
    st.top  = y + "px";
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.prototype.SetHPointer = function(y)
{
    var abs_X = getAbsPosX(this.prefix + "hue");
    var abs_Y = getAbsPosY(this.prefix + "hue");

    if ((y - abs_Y) < 0) y = abs_Y;
    if (y > (abs_Y + 257)) y = abs_Y + 257;

    window.colorbox.hue = ((y - abs_Y) == 0) ? 0 : (1 - (y - abs_Y)/257);
    var rgb = hsv2rgb(this.hue, 1, 1);
    var hex = rgb2hex(rgb);
    document.getElementById(this.prefix + "gradient").style.backgroundColor = "#" + hex;

    var t = 11/2;
    document.getElementById(this.prefix + "cur_pos_hue").style.left = (abs_X - 7) + "px";
    if ((y - abs_Y) <= 0)   y = abs_Y + 1;
    if (y > (abs_Y + 256)) y = abs_Y + 256;
    document.getElementById(this.prefix + "cur_pos_hue").style.top  = (y - Math.ceil(t) + 1) + "px";

    this.UpdateInfo();
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.prototype.SetSVPointer = function(x, y)
{
    var abs_X = getAbsPosX(this.prefix + "gradient");
    var abs_Y = getAbsPosY(this.prefix + "gradient");

    if ((x - abs_X) < 0) x = abs_X;
    if (x > (abs_X + 257)) x = abs_X + 257;
    if ((y - abs_Y) < 0) y = abs_Y;
    if (y > (abs_Y + 257)) y = abs_Y + 257;

    this.sat = (x - abs_X)/257;
    this.val = 1 - (y - abs_Y)/257;

    var rgb = hsv2rgb(this.hue, this.sat, this.val)
    var tmp = (rgb[0]*0.3 + rgb[1]*0.49 + rgb[2]*0.11);
    var hex = rgb2hex(new Array((255 - tmp), (255 - tmp), (255 - tmp)));
    var t = 7/2;

    document.getElementById(this.prefix + "cur_pos_grad").style.left = (x - Math.ceil(t)) + "px";
    document.getElementById(this.prefix + "cur_pos_grad").style.top  = (y - Math.ceil(t)) + "px";
    document.getElementById(this.prefix + "cur_pos_grad").style.borderColor = "#" + hex;

    this.UpdateInfo();
}


//------------------------------------------------------------------
//???
//------------------------------------------------------------------
ColorBox.prototype.UpdateInfo = function() {
    var rgb = hsv2rgb(this.hue, this.sat, this.val)
    var hex = rgb2hex(rgb);
    document.getElementById(this.prefix + "hue_text").value = Math.round(360 * this.hue);
    document.getElementById(this.prefix + "sat_text").value = Math.round(100 * this.sat);
    document.getElementById(this.prefix + "val_text").value = Math.round(100 * this.val);

    document.getElementById(this.prefix + "r_text").value = rgb[0];
    document.getElementById(this.prefix + "g_text").value = rgb[1];
    document.getElementById(this.prefix + "b_text").value = rgb[2];
    document.getElementById(this.prefix + "color_preview").style.backgroundColor = "#" + hex;
    document.getElementById(this.prefix + "hex_text").value = hex;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.onClose = function() {
    document.getElementById(window.colorbox.prefix + "window").style.visibility       = "hidden";
    document.getElementById(window.colorbox.prefix + "cur_pos_grad").style.visibility = "hidden";
    document.getElementById(window.colorbox.prefix + "cur_pos_hue").style.visibility  = "hidden";
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.onOk = function() {
    var rgb = hsv2rgb(window.colorbox.hue, window.colorbox.sat, window.colorbox.val)
    var hex = rgb2hex(rgb);
    document.getElementById(window.colorbox.prefix + "window").style.visibility       = "hidden";
    document.getElementById(window.colorbox.prefix + "cur_pos_grad").style.visibility = "hidden";
    document.getElementById(window.colorbox.prefix + "cur_pos_hue").style.visibility  = "hidden";
    document.getElementById(window.colorbox.prefix + "cur_pos_grad").style.visibility = "hidden";
    if (window.colorbox.id_text  != null) document.getElementById(window.colorbox.id_text).value = "#" + hex;
    if (window.colorbox.id_color != null) document.getElementById(window.colorbox.id_color).style.backgroundColor = "#" + hex;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
ColorBox.prototype.Show = function(x, y) {
    if ((x != null) && (y != null)) {
        this.SetPos(x, y);
    } else {
        this.SetPos(document.body.scrollLeft + (document.body.clientWidth - 480)/2, document.body.scrollTop + (document.body.clientHeight - 287)/2);
    }
    document.getElementById(window.colorbox.prefix + "window").style.visibility       = "visible";
    document.getElementById(window.colorbox.prefix + "cur_pos_grad").style.visibility = "visible";
    document.getElementById(window.colorbox.prefix + "cur_pos_hue").style.visibility  = "visible";
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function Init() {
    window.colorbox = new ColorBox();
    window.colorbox.Init("#000000");
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
function ShowColorBox(init_color, id_text, id_color, x, y, title) {
    if (window.colorbox == null) {
        Init();
    } else {
        ColorBox.onClose();
    }
    window.colorbox.id_text  = id_text;
    window.colorbox.id_color = id_color;
    if (init_color != 'null') window.colorbox.SetCustomColor(init_color);
    if (title      != null) window.colorbox.SetTitleText(title);
    window.colorbox.Show();
}

//addLoadEvent(Init);