<?php
//$Id$

class AffiliatePro extends Module
{
    function __construct()
    {

        $this->name = 'affiliatepro';
        $this->tab = 'Tools';
        $this->version = '1.2.5.0';
        $this->page = basename(__FILE__, '.php');

        parent::__construct();

        $this->displayName = $this->l('Affiliate Pro');
        $this->description = $this->l('Affiliate software, PHP affiliate network tracking software');
        $this->confirmUninstall = $this->l('Are you sure you want to delete your details ?');
    }


    public function install()
    {
        if (!parent::install()
            OR !Configuration::updateValue('AFFPRO_URL', 'http://your_affiliatepro_url/')
            OR !$this->registerHook('orderConfirmation'))
            return false;
        return true;
    }

    public function uninstall()
    {
        if (!Configuration::deleteByName('AFFPRO_URL')
            OR !parent::uninstall())
            return false;
        return true;
    }

    public function getContent()
    {
        $this->_html = '<h2>Affiliate Pro Script</h2>';
        //POST method
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['submitButton']))
        {
          //url
          $AFFPRO_URL = rtrim($_POST['url'], '/\\');
//          if (false === @file_get_contents($AFFPRO_URL . '/callbacks/callback_sample.php')) {
//            $this->_postErrors[] = $this->l('Enter correct \'' . $this->l('URL to Affiliate Pro') . '\'');
//          }
          //save settings
          if (!sizeof($this->_postErrors))
          {
            Configuration::updateValue('AFFPRO_URL', $AFFPRO_URL);
            $this->displayConf();
          }
          else {
            $this->displayErrors();
          }
        }
        //display form settings
        $this->displayFormHeader();
        $this->displayFormSettings();
        return $this->_html;
    }

    public function displayConf()
    {
        $this->_html .= '
        <div class="conf confirm">
            <img src="../img/admin/ok.gif" alt="'.$this->l('Confirmation').'" />
            '.$this->l('Settings updated').'
        </div>';
    }

    public function displayErrors()
    {
        $nbErrors = sizeof($this->_postErrors);
        $this->_html .= '
        <div class="alert error">
            <h3>'.($nbErrors > 1 ? $this->l('There are') : $this->l('There is')).' '.$nbErrors.' '.($nbErrors > 1 ? $this->l('errors') : $this->l('error')).'</h3>
            <ol>';
        foreach ($this->_postErrors as $error) {
          $this->_html .= '<li>'.$error.'</li>';
        }
        $this->_html .= '
            </ol>
        </div>';
    }

    public function displayFormHeader()
    {
        $this->_html .= ''
        . '<img src="../modules/affiliatepro/affiliatepro.gif" style="float:left; margin-right:15px;" />'
        . '<br /><b>'.$this->l('Installing affiliate script to your site will be one of the best ways to get more traffic and increase sales volume!').'</b><br class="clear" /><br />'
        . $this->l('Web Page').': <a href="http://www.affiliateproscript.com/" target="_blank">http://www.affiliateproscript.com/</a><br />'
        . $this->l('Documentation').': <a href="http://www.affiliateproscript.com/doc/Affiliate_PRO_doc.pdf" target="_blank">http://www.affiliateproscript.com/doc/Affiliate_PRO_doc.pdf</a><br />'
        . $this->l('Support forum').': <a href="http://www.softservice.org/support/viewforum.php?f=6" target="_blank">http://www.softservice.org/support/viewforum.php?f=6</a><br />'
        . $this->l('Tech.support email').': <a href="mailto:support@affiliateproscript.com" target="_blank">support@affiliateproscript.com</a><br />'
        . '<br /><br /><br />';

    }

    public function displayFormSettings()
    {
        $conf = Configuration::getMultiple(array('AFFPRO_URL'));
        $this->_html .= '
        <form action="'.$_SERVER['REQUEST_URI'].'" method="post">
        <fieldset>
            <legend><img src="../img/admin/contact.gif" />'.$this->l('Settings').'</legend>
            <label>'.$this->l('URL to Affiliate Pro').'</label>
            <div class="margin-form"><input type="text" name="url" value="'.htmlentities($conf['AFFPRO_URL'], ENT_COMPAT, 'UTF-8').'" style="width:300px;" /></div>
            <br /><div align="center"><input type="submit" name="submitButton" value="'.$this->l('Update settings').'" class="button" /></div>
        </fieldset>
        </form>';
    }

    function hookOrderConfirmation($params)
    {
        if (!$this->active) {
          return;
        }
        global $smarty;
        $conf = Configuration::getMultiple(array('AFFPRO_URL'));

        $smarty->assign(array(
        'AFFPRO_URL' => $conf['AFFPRO_URL'],
        'txn_id' => $params['objOrder']->id_cart,
        'amount' => $params['objOrder']->total_products,
        'customer_id' => $params['objOrder']->id_customer,
        'currency_iso_code' => $params['currencyObj']->iso_code,
        ));
        return $this->display(__FILE__, 'affiliatepro.tpl');
    }

}

?>