<?php

/**
  * Backup Database class, backup.db.php
  * Backup Database management
  * @category classes
  *
  * @author Julien Breux <support@julienbreux.com>
  * @copyright Julien Breux
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 1.0
  *
  */

class BackupDB
{
	/** @var string dbHost */
	private $dbHost;
	
	/** @var string dbUsername */
	private $dbUsername;

	/** @var string dbPassword */
	private $dbPassword;

	/** @var string dbDatabase */
	private $dbDatabase;

	/** @var mixed dbPrefix */
	private $dbPrefix;

	/** @var mixed dbResource */
	private $dbResource;

	/** @var string moduleDir */
	private $moduleDir;

	/** @var string filesDir */
	private $filesDir = 'dbcopies';

	/** @var string fileName */
	private $fileName;

	/** @var string fileExtension */
	private $fileExtension = '.txt';

	/** @var string fileResource */
	private $fileResource;

	/** @var string error */
	public $error;

	/**
	 * Build object
	 */
	public function __construct()
	{
		$this->dbHost = _DB_SERVER_;
		$this->dbUsername = _DB_USER_;
		$this->dbPassword = _DB_PASSWD_;
		$this->dbDatabase = _DB_NAME_;
		$this->moduleDir = realpath(dirname(__FILE__).'/../');
		$this->fileName = str_replace('.', '', _PS_VERSION_).'_'.date('d-m-y_H\hi');
		self::dbConnect();
		self::Backup();
	}

	/**
	 * Open database connection
	 */
	private function dbConnect()
	{
		if($this->dbResource = @mysql_connect($this->dbHost, $this->dbUsername, $this->dbPassword))
		{
			if(!mysql_select_db($this->dbDatabase, $this->dbResource))
			{
				die(Tools::displayError('The database selection cannot be made.'));
		  }
		}
		else
		{
			die(Tools::displayError('Link to database cannot be established.'));
		}
		mysql_query("SET NAMES 'utf8'", $this->dbResource);
		return $this->dbResource;
	}

  private function Backup()
  {
    self::fileOpen();
    $content  = "# Database Backup ".date('Y-m-d H:i').PHP_EOL;
    $content .= "# Generated by Prestashop Backup Module".PHP_EOL;
    $content .= "# Author Julien Breux".PHP_EOL.PHP_EOL;

    $content .= "# Delete all".PHP_EOL;
    $tables = mysql_list_tables($this->dbDatabase, $this->dbResource);
    while(list($table) = mysql_fetch_row($tables))
    {
      $content .= "DELETE FROM `$table`;".PHP_EOL;
    }

    $tables = mysql_list_tables($this->dbDatabase, $this->dbResource);
    while(list($table) = mysql_fetch_row($tables))
    {
      $query = mysql_query("SELECT * FROM $table");
      $numFields = mysql_num_fields($query);
      if(mysql_num_rows($query) != 0)
      {
        $content .= "INSERT INTO `$table` VALUES".PHP_EOL;
        $line = '';
        while($value = mysql_fetch_array($query))
        {
          $line .= "(";
          for($i=0; $i<$numFields; $i++)
          {
            if($i > 0)
            {
              $line .= ", ";
            }
            $line .= "'".utf8_decode(addslashes($value[$i]))."'";
          }
          $line .= "),".PHP_EOL;
        }
        $x = 1+strlen(PHP_EOL);
        $line = substr($line, 0, -$x);
        $content .= $line.";".PHP_EOL.PHP_EOL;
      }
    } 
    fputs($this->fileResource, $content);
    self::fileClose();
  }

  private function fileOpen()
  {
    $filename = $this->moduleDir.DIRECTORY_SEPARATOR.$this->filesDir.DIRECTORY_SEPARATOR.$this->fileName.$this->fileExtension;
    $this->fileResource = @fopen($filename, 'w');
    if($this->fileResource === FALSE)
    {
      die(Tools::displayError('Unable to create a temporary file.'));
    }
    return $this->fileResource;
  }

  private function fileClose()
  {
		if($this->fileResource)
		{
			fclose($this->fileResource);
		}
		$this->fileResource = FALSE;
  }
}
?>