<?php

/**
  * Restore Database class, restore.db.php
  * Restore Database management
  * @category classes
  *
  * @author Julien Breux <support@julienbreux.com>
  * @copyright Julien Breux
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 1.0
  *
  */

class RestoreDB
{
	/** @var string dbHost */
	private $dbHost;
	
	/** @var string dbUsername */
	private $dbUsername;

	/** @var string dbPassword */
	private $dbPassword;

	/** @var string dbDatabase */
	private $dbDatabase;

	/** @var mixed dbPrefix */
	private $dbPrefix;

	/** @var mixed dbResource */
	private $dbResource;

	/** @var string moduleDir */
	private $moduleDir;

	/** @var string filesDir */
	private $filesDir = 'dbcopies';

	/** @var string fileName */
	private $fileName;

	/** @var string fileContent */
	private $fileContent;

	/** @var string error */
	public $error;

	/**
	 * Build object
	 */
	public function __construct($filename)
	{
		$this->dbHost = _DB_SERVER_;
		$this->dbUsername = _DB_USER_;
		$this->dbPassword = _DB_PASSWD_;
		$this->dbDatabase = _DB_NAME_;
		$this->moduleDir = realpath(dirname(__FILE__).'/../');
		$this->fileName = $filename;
		self::dbConnect();
		if(file_exists($this->moduleDir.DIRECTORY_SEPARATOR.$this->filesDir.DIRECTORY_SEPARATOR.$this->fileName) && !empty($this->fileName))
		{
		  self::Restore();
		}
		else
		{
		  $this->error = 1;
		}
	}

	/**
	 * Open database connection
	 */
	private function dbConnect()
	{
		if($this->dbResource = @mysql_connect($this->dbHost, $this->dbUsername, $this->dbPassword))
		{
			if(!mysql_select_db($this->dbDatabase, $this->dbResource))
			{
				die(Tools::displayError('The database selection cannot be made.'));
		  }
		}
		else
		{
			die(Tools::displayError('Link to database cannot be established.'));
		}
		mysql_query("SET NAMES 'utf8'", $this->dbResource);
		return $this->dbResource;
	}

  private function Restore()
  {
    self::fileLoad();
    $lines = explode(PHP_EOL, $this->fileContent);
    $querie = '';
    foreach($lines as $line)
    {
      if(!empty($line) && substr($line, 0, 1) != '#')
      {
        if(substr($line, 0, 6) == 'DELETE')
        {
          $querie = $line;
          mysql_query($querie, $this->dbResource);
        }
        elseif(substr($line, 0, 6) == 'INSERT')
        {
          $querie = $line;
        }
        elseif(substr($line, -2, 2) == ');')
        {
          $querie .= $line;
          mysql_query($querie, $this->dbResource);
        }
        else //if(substr($line, 0, 2) == '(\'' && substr($line, -2, 2) != ');')
        {
          $querie .= $line;
        }
      }
    }
  }

  private function fileLoad()
  {
    $filename = $this->moduleDir.DIRECTORY_SEPARATOR.$this->filesDir.DIRECTORY_SEPARATOR.$this->fileName.$this->fileExtension;
    $this->fileContent = file_get_contents($filename);
  }
}
?>