<?php
/**
 * easyupdate module
 *
 * @category Prestashop
 * @category Module
 * @author Samdha <contact@samdha.net>
 * @copyright Samdha
 * @license commercial license see license.txt
 * @author logo Oxygen Team http://www.oxygen-icons.org/
 * @license logo http://www.gnu.org/copyleft/gpl.html GPLv3
 * @version 2.8.0.0
**/

if (!class_exists('easyupdate', false)) {
	require_once(_PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'easyupdate'.DIRECTORY_SEPARATOR.'classes'.DIRECTORY_SEPARATOR.'modulesamdha.php');
	class easyupdate extends modulesamdha
	{
		public $shortName = 'easyupdate';
		
		public function __construct() {
			$this->name = 'easyupdate';
			$this->tab = version_compare(_PS_VERSION_, '1.4.0.0', '<')?'Tools':'administration';
			$this->version = '2.8.0.0';
			$module_key = 'cb42e6fa4580a0339cd9d49379864318';
			
			parent::__construct();
			
			$this->displayName = $this->l('Prestashop Easy Update');
			$this->description = $this->l('Update Prestashop easily and securely');
			$this->descriptionBig = '
					<p>
					'.$this->l('This module allows you to update Prestashop easily and securely with only one click.').'
					</p>
					<p>
					'.$this->l('Files and database are backuped before any modification, so if something goes wrong, everything is automaticaly restored.').'
					</p>';
		}
		
		public function install() {

			if (!parent::install()
				OR (Hook::get('backOfficeHome')?!$this->registerHook('backOfficeHome'):false)
				OR !Configuration::updateValue($this->shortName.'_password', strtoupper(Tools::passwdGen(16)))
				)
				return false;
			return true;
		}
		
		public function uninstall()
		{
			if (!parent::uninstall()
				OR !Configuration::deleteByName($this->shortName.'_password')
				)
				return false;
			return true;
		}
		
		public function _postProcess($token) {
			global $currentIndex, $cookie;
			$this->canUpdate = true;
			if (@ini_get('safe_mode')) {
				$this->_postErrors[] = '<b>safe_mode</b> '.$this->l('is activated.');
				$this->canUpdate = false;
			}
			if (!@ini_get('allow_url_fopen') && !function_exists('curl_init')) {
				$this->_postErrors[] = '<b>allow_url_fopen</b> and <b>curl</b> '.$this->l('are not activated.');
				$this->canUpdate = false;
			}
			if (!is_writable(dirname(__FILE__))) {
				$this->_postErrors[] = $this->l('The module folder is not writable.');
				$this->canUpdate = false;
			} elseif (!is_writable(dirname(__FILE__).DIRECTORY_SEPARATOR.'backup')) {
				$this->_postErrors[] = $this->l('The backup folder is not writable.');
				$this->canUpdate = false;
			}
			
			$ftp = false;
			if ($this->config[$this->shortName.'_host']
				&& !$this->checkFTPConnection($this->config[$this->shortName.'_host'],
											  $this->config[$this->shortName.'_login'],
											  $this->config[$this->shortName.'_ftppass'],
											  $this->config[$this->shortName.'_path'])
				)
				$this->_postErrors[] = $this->l('Unable to use FTP access.');
			elseif ($this->config[$this->shortName.'_host'])
				$ftp = true;
				
			if (!$ftp
				&& !is_writable(_PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'index.php')) {
				$this->_postErrors[] = $this->l('Some core files are not writable.');
				$this->canUpdate = false;
			}
			
			if ($this->detect_apache_mod('mod_evasive') ){
				$this->_postWarnings[] = '<b>mod_evasive</b> '.$this->l('is activated.').' '.$this->l('Update will be slower.').'</li>';
			}
			
			return parent::_postProcess($token);
		}
		
		/**
		 * display admin form
		 * 
		 * @param string $token
		 * @return string The from
		 */
		public function _displayForm($token, $big = true, $space = false) {
			global $currentIndex, $cookie;
			$highterVersions = $this->getHighterVersions();
			$admin_dir = explode('/', dirname($_SERVER['SCRIPT_NAME']));
			$admin_dir = end($admin_dir);
            $iso_lang = Language::getIsoById($cookie->id_lang);

			$output = parent::_displayForm($token, false);
            if (version_compare(_PS_VERSION_, '1.0.0.8', '<'))
            	$output .= '<script src="//ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>';
			
			$output .= '
				<fieldset class="width3">
					<legend>'.$this->l('Update').'</legend>
					<ul style="list-style: none; margin-left: 0; padding-left: 0;">
						<li><img src="'.$this->_path.'img/information.png" alt="information"/> '.$this->l('Your Prestashop version is:').' <b>'._PS_VERSION_.'</b></li>';
			if (!$highterVersions) {
				$output .= '<li><img src="'.$this->_path.'img/information.png" alt="information"/> '.$this->l('Latest Prestashop version available is:').' <b>'._PS_VERSION_.'</b></li>';
				$this->canUpdate = false;
			} else {
				$tmp = array_keys($highterVersions);
				$output .= '<li><img src="'.$this->_path.'img/information.png" alt="information"/> '.$this->l('Latest Prestashop version available is:').' <b>'.reset($tmp).'</b></li>';
			}
			$output .= '
					</ul><br/>';
			if ($this->canUpdate) {
				$output .= '<p>'.$this->l('Update to').' <select id="selectedVersion">';
				foreach ($highterVersions as $version => $filename)
					$output .= '<option value="'.$filename.'">'.$version.'</option>';
				
				$output .= '
					</select> <span id="easyupdate" class="button" style="cursor: pointer">'.$this->l('Ok').'</span>
							<input id="backup" checked="checked" type="checkbox" />' . $this->l('Do the backup') . '
					</p>
					<pre id="updateProgress" style="display: none; overflow-y: scroll; height: 170px; width: 575px; padding: 10px; margin-top: 1em;clear: both; color: #33d011; font-family: monospace; font-size: 12px; line-height: 1.4em; background: #000; border: 1px solid; border-color: #555 #DDD #DDD #555">'.$this->l('Update progress :').'<br/></pre>';
			}
			else
				$output .= '<p>'.$this->l('Can\'t update yet.').'</p>';
			$output .= '
				</fieldset>';
			if (file_exists(_PS_ROOT_DIR_.'/modules/'.$this->name.'/backup/files.zip') &&
				file_exists(_PS_ROOT_DIR_.'/modules/'.$this->name.'/backup/database1.sql'))
				$output .= '
					<fieldset class="width3 space">
						<legend>'.$this->l('Restoration').'</legend>
						<p style="width: auto" class="warning">'.$this->l('The restoration will delete all orders, customers, informations created since').' '.Tools::displayDate(date("Y-m-d H:i:s", filemtime(_PS_ROOT_DIR_.'/modules/'.$this->name.'/backup/files.zip')), $cookie->id_lang, true).'</p>
						<p>'.$this->l('Backup files are stored on your server, so you can').'</p>
						<p><span id="easyupdate_restore" class="button" style="cursor: pointer">'.$this->l('Restore your shop').'</span> '.$this->l('or').' <span id="easyupdate_delete" class="button" style="cursor: pointer">'.$this->l('Delete them').'</span>.</p>
						<pre id="restoreProgress" style="display: none; overflow-y: scroll; height: 170px; width: 575px; padding: 10px; margin-top: 1em;clear: both; color: #33d011; font-family: monospace; font-size: 12px; line-height: 1.4em; background: #000; border: 1px solid; border-color: #555 #DDD #DDD #555">'.$this->l('Restoration progress :').'<br/></pre>
					</fieldset>';
			$output .= '
				<fieldset class="width3 space">
					<legend>'.$this->l('Informations').'</legend>';
			if( ini_get('safe_mode') )
				$output .= '
					<p>'.$this->l('The PHP safe mode is an attempt to solve the shared-server security problem. This feature has been DEPRECATED. Relying on this feature is highly discouraged.').' [<a href="http://php.net/manual/en/features.safe-mode.php">'.$this->l('more infos').'</a>]</p>
					<hr/>';
			if (!@ini_get('allow_url_fopen'))
				$output .= '
					<p>'.$this->l('To update PrestaShop, you need to activate the <b>allow_url_fopen</b> command in your <b>php.ini</b> config file.').' [<a href="http://www.php.net/manual/en/filesystem.configuration.php#ini.allow-url-fopen">'.$this->l('more infos').'</a>]</p>
					<p>'.$this->l('If you don\'t know how to do that, please contact your host administrator !').'</p>
					<hr/>';
			if (!is_writable(dirname(__FILE__))
				|| !is_writable(dirname(__FILE__).DIRECTORY_SEPARATOR.'backup'))
				$output .= '
					<p>'.$this->l('To make a folder writable, set its permissions to 775 with your FTP client.').' [<a href="http://www.stadtaus.com/en/tutorials/chmod-ftp-file-permissions.php">'.$this->l('more infos').'</a>]</p>
					<hr/>';
			if (!is_writable(_PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'index.php'))
				$output .= '
					<p>'.$this->l('To make a file writable, set its permissions to 777 with your FTP client.').' [<a href="http://www.stadtaus.com/en/tutorials/chmod-ftp-file-permissions.php">'.$this->l('more infos').'</a>]</p>
					<hr/>';
				$output .= '
					<p>'.$this->l('If you have made core modifications on Prestashop, they will be erased.').'</p>
					<p>'.$this->l('Your modules and theme must be compatible with the version of Prestashop you want to install.').'</p>
				</fieldset>
				<script type="text/javascript">
					var currentAjax = {rien : 1};
					$(document).ready(function(){
						$("#easyupdate").click(function() {
							window.onbeforeunload = function() {
								return "'.$this->l('The update is not finished.').'";
							}
						
							$(this).parent("p").hide();
							$("#updateProgress").show();
							if ($("#backup").is(":checked"))
							{
								easyupdate("start", "#updateProgress");
							}
							else
							{
								easyupdate("start", "#updateProgress","false");
							}

						});
						$("#easyupdate_restore").click(function() {
							window.onbeforeunload = function() {
								return "'.$this->l('The restoration is not finished.').'";
							}
							$(this).parents("p").hide();
							$("#restoreProgress").show();
							easyupdate("preRestore", "#restoreProgress");
						});
						$("#easyupdate_delete").click(function() {
							$(this).parents("p").hide();
							easyupdate("preDeleteBackup", "#updateProgress");
						});
					});
					
					function easyupdate(nextStep, console, backup = "true" ) {
						currentAjax = $.ajax({
							url: "'.$this->_path.'easyupdate_ajax.php",
							async: true,
							data: {
								back_up: backup,
								nextStep: nextStep,
								admin_dir: '.json_encode($admin_dir).',
								url: $("#selectedVersion").val(),
								token: '.json_encode($this->config[$this->shortName.'_password']).',
								rand: (new Date()).getDate()},
							success: function(data) {
								var line = "";
								if (data.error == 2) {
									 line += "<span style=\'color: red\'>";
									 line += '.json_encode($this->l('Can not open installation script automaticaly, please')).' + " <a target=\'_blank\' style=\'color:orange\' href=\'../install/\'>" + '.json_encode($this->l('click here')).' + " </a><br/>";
									 line += '.json_encode($this->l(' and then when the upgrade is finish,')).' + " <a style=\'color:orange\' onclick=\'easyupdate(\"deleteTmp\", \"#updateProgress\");\'>" + '.json_encode($this->l('click here')).' + " </a>";
									 line += "</span>";
								} else {
									if (data.error == 1) line += "<span style=\'color: red\'>";
									line += data.information;
									if (data.error == 1) line += "</span>";
								}
								line += "<br/>";
								$(console).append(line);
								try { // for PS 1.0.0.8
									$(console).scrollTop($(console)[0].scrollHeight);
								}
								catch(err) {
								}								
								
								if (data.error != 2) {
									if (data.nextStep != -1)
										easyupdate(data.nextStep, console);
									else {
										window.onbeforeunload = null;
										alert('.json_encode($this->l('Process ended.')).');
									}
								}
							},
							error: function(data, error) {
								var line = "";
								line += "<span style=\'color: red\'>";
								line += '.json_encode($this->l('The server did not respond correctly, please send the informations belows to Samdha.')).' + "<br/>";
								line += '.json_encode($this->l('Step :')).' + nextStep + "<br/>";
								line += '.json_encode($this->l('Error :')).' + error + "<br/>";
								line += '.json_encode($this->l('Server response :')).' + data.responseText;
								line += "</span>";
								line += "<br/>";
								$(console).append(line);
								window.onbeforeunload = null;
								alert('.json_encode($this->l('Sorry, there was a problem.')).');
							},
							dataType: "json",
							cache : false
						});
					}
				</script>
				<form action="'.$currentIndex.'&amp;configure='.$this->name.'&amp;token='.$token.'" method="post">				
					<fieldset class="width3 space">
						<legend>'.$this->l('Parameters').'</legend>
						<label for="'.$this->shortName.'_final">'.$this->l('Display only final versions').'</label>
						<div class="margin-form" style="padding-top:5px;">
							<label class="t" for="'.$this->shortName.'_final_on"><img src="../img/admin/enabled.gif" alt="'.$this->l('Yes').'" title="'.$this->l('Yes').'" /></label>
							<input type="radio" name="'.$this->shortName.'_final" id="'.$this->shortName.'_final_on" value="1"'.((bool) $this->config[$this->shortName.'_final'] ? ' checked="checked"' : '').' />
							<label class="t" for="'.$this->shortName.'_final_on"> '.$this->l('Yes').'</label>
							<label class="t" for="'.$this->shortName.'_final_off"><img src="../img/admin/disabled.gif" alt="'.$this->l('No').'" title="'.$this->l('No').'" style="margin-left: 10px;" /></label>
							<input type="radio" name="'.$this->shortName.'_final" id="'.$this->shortName.'_final_off" value="0" '.(!(bool) $this->config[$this->shortName.'_final'] ? 'checked="checked"' : '').'/>
							<label class="t" for="'.$this->shortName.'_final_off"> '.$this->l('No').'</label>
							<a href="http://documentation.samdha.net/'.$iso_lang.'/easyupdate#final"><img src="'._PS_ADMIN_IMG_.'help.png" style="vertical-align: middle" width="16" height="16" alt="?" /></a>
						</div>
						<div class="clear '.$this->shortName.'_host">
							<label for="'.$this->shortName.'_host">'.$this->l('FTP host').'</label>
							<div class="margin-form">
								<input name="'.$this->shortName.'_host" id="'.$this->shortName.'_host" value="'.$this->config[$this->shortName.'_host'].'"/>
								<a href="http://documentation.samdha.net/'.$iso_lang.'/easyupdate#ftp"><img src="'._PS_ADMIN_IMG_.'help.png" style="vertical-align: middle" width="16" height="16" alt="?" /></a>
							</div>
						</div>
						<div class="clear '.$this->shortName.'_login">
							<label for="'.$this->shortName.'_login">'.$this->l('FTP login').'</label>
							<div class="margin-form">
								<input name="'.$this->shortName.'_login" id="'.$this->shortName.'_login" value="'.$this->config[$this->shortName.'_login'].'"/>
								<a href="http://documentation.samdha.net/'.$iso_lang.'/easyupdate#ftp"><img src="'._PS_ADMIN_IMG_.'help.png" style="vertical-align: middle" width="16" height="16" alt="?" /></a>
							</div>
						</div>
						<div class="clear '.$this->shortName.'_ftppass">
							<label for="'.$this->shortName.'_ftppass">'.$this->l('FTP password').'</label>
							<div class="margin-form">
								<input name="'.$this->shortName.'_ftppass" id="'.$this->shortName.'_ftppass" value="'.$this->config[$this->shortName.'_ftppass'].'"/>
								<a href="http://documentation.samdha.net/'.$iso_lang.'/easyupdate#ftp"><img src="'._PS_ADMIN_IMG_.'help.png" style="vertical-align: middle" width="16" height="16" alt="?" /></a>
							</div>
						</div>
						<div class="clear '.$this->shortName.'_path">
							<label for="'.$this->shortName.'_path">'.$this->l('FTP path').'</label>
							<div class="margin-form">
								<input name="'.$this->shortName.'_path" id="'.$this->shortName.'_path" value="'.$this->config[$this->shortName.'_path'].'"/>
								<a href="http://documentation.samdha.net/'.$iso_lang.'/easyupdate#ftp"><img src="'._PS_ADMIN_IMG_.'help.png" style="vertical-align: middle" width="16" height="16" alt="?" /></a>
							</div>
						</div>
					</fieldset>
					<p><input type="submit" class="button" name="saveSettings" value="'.$this->l('Save').'" /></p>
				</form>
				<br style="clear: both"/>
			';
			return $output;
		}
		
		public function writeConfigFile($nextStep = 1) {
			global $smarty;
			$this->getConfig();
			$result = array();
			if (Tools::getValue('token') == $this->config[$this->shortName.'_password']) {
				$use_ftp = ($this->config[$this->shortName.'_host']
							&& $this->checkFTPConnection($this->config[$this->shortName.'_host'],
														  $this->config[$this->shortName.'_login'],
														  $this->config[$this->shortName.'_ftppass'],
														  $this->config[$this->shortName.'_path'])
							);
				$url = base64_decode(Tools::getValue('url'));
				preg_match('/prestashop_([0-9\.]+)\.zip/', $url, $new_version);

				$text = '<?php '.
						'$_PS_VERSION_ = \''.addslashes(_PS_VERSION_).'\';'.
						"\n".'$_PS_VERSION_NEW_ = \''.addslashes($new_version[1]).'\';'.
						"\n".'$_PS_ROOT_DIR_ = \''.addslashes(_PS_ROOT_DIR_).'\';'.
						"\n".'$_PS_ADMIN_DIR_ = \''.addslashes(_PS_ROOT_DIR_.DIRECTORY_SEPARATOR.Tools::getValue('admin_dir')).'\';'.
						"\n".'$__PS_BASE_URI__ = \''.addslashes($this->getHttpHost(true).__PS_BASE_URI__).'\';'.
						"\n".'$_DB_SERVER_ = \''.addslashes(_DB_SERVER_).'\';'.
						"\n".'$_DB_NAME_ = \''.addslashes(_DB_NAME_).'\';'.
						"\n".'$_DB_USER_ = \''.addslashes(_DB_USER_).'\';'.
						"\n".'$_DB_PASSWD_ = \''.addslashes(_DB_PASSWD_).'\';'.
						"\n".'$_DB_PREFIX_ = \''.addslashes(_DB_PREFIX_).'\';'.
						"\n".'$URL = \''.addslashes($url).'\';'.
						"\n".'$USE_FTP = '.((bool) $use_ftp?'1':'0').';'.
						"\n".'$FTP_HOST = \''.addslashes($this->config[$this->shortName.'_host']).'\';'.
						"\n".'$FTP_LOGIN = \''.addslashes($this->config[$this->shortName.'_login']).'\';'.
						"\n".'$FTP_PASS = \''.addslashes($this->config[$this->shortName.'_ftppass']).'\';'.
						"\n".'$FTP_PATH = \''.addslashes($this->config[$this->shortName.'_path']).'\';'.
						"\n".'$l = array();'.
						"\n".'$l[\'Backup\'] = \''.addslashes($this->l('Backup')).'\';'.
						"\n".'$l[\'Backup database...\'] = \''.addslashes($this->l('Backup database...')).'\';'.
						"\n".'$l[\'Backup existing files...\'] = \''.addslashes($this->l('Backup existing files...')).'\';'.
						"\n".'$l[\'Can not download the current version (skipping)\'] = \''.addslashes($this->l('Can not download the current version (skipping)')).'\';'.
						"\n".'$l[\'Can not download the latest version\'] = \''.addslashes($this->l('Can not download the latest version')).'\';'.
						"\n".'$l[\'Can not list files of the current version (skipping)\'] = \''.addslashes($this->l('Can not list files of the current version (skipping)')).'\';'.
						"\n".'$l[\'Can not open installation script. Please execute it yourself here :\'] = \''.addslashes($this->l('Can not open installation script. Please execute it yourself here :')).'\';'.
						"\n".'$l[\'Delete\'] = \''.addslashes($this->l('Delete')).'\';'.
						"\n".'$l[\'Delete completed.\'] = \''.addslashes($this->l('Delete completed.')).'\';'.
						"\n".'$l[\'Delete temporary files...\'] = \''.addslashes($this->l('Delete temporary files...')).'\';'.
						"\n".'$l[\'Download current version informations...\'] = \''.addslashes($this->l('Download current version informations...')).'\';'.
						"\n".'$l[\'Download latest version...\'] = \''.addslashes($this->l('Download latest version...')).'\';'.
						"\n".'$l[\'Error during database backup...\'] = \''.addslashes($this->l('Error during database backup...')).'\';'.
						"\n".'$l[\'Error during database restoration.\'] = \''.addslashes($this->l('Error during database restoration.')).'\';'.
						"\n".'$l[\'Error during files replacement...\'] = \''.addslashes($this->l('Error during files replacement...')).'\';'.
						"\n".'$l[\'Execute installation script...\'] = \''.addslashes($this->l('Execute installation script...')).'\';'.
						"\n".'$l[\'Extract files...\'] = \''.addslashes($this->l('Extract files...')).'\';'.
						"\n".'$l[\'files left\'] = \''.addslashes($this->l('files left')).'\';'.
						"\n".'$l[\'Find files to backup...\'] = \''.addslashes($this->l('Find files to backup...')).'\';'.
						"\n".'$l[\'Find files to delete...\'] = \''.addslashes($this->l('Find files to delete...')).'\';'.
						"\n".'$l[\'Find modules to update...\'] = \''.addslashes($this->l('Find modules to update...')).'\';'.
						"\n".'$l[\'Installation script terminates with error\'] = \''.addslashes($this->l('Installation script terminates with error')).'\';'.
						"\n".'$l[\'is not activated\'] = \''.addslashes($this->l('is not activated')).'\';'.
						"\n".'$l[\'is not readable\'] = \''.addslashes($this->l('is not readable.')).'\';'.
						"\n".'$l[\'is not writable\'] = \''.addslashes($this->l('is not writable.')).'\';'.
						"\n".'$l[\'Remove exemple files\'] = \''.addslashes($this->l('Remove exemple files')).'\';'.
						"\n".'$l[\'Replace\'] = \''.addslashes($this->l('Replace')).'\';'.
						"\n".'$l[\'Restoration completed.\'] = \''.addslashes($this->l('Restoration completed.')).'\';'.
						"\n".'$l[\'Restore database...\'] = \''.addslashes($this->l('Restore database...')).'\';'.
						"\n".'$l[\'Restore files...\'] = \''.addslashes($this->l('Restore files...')).'\';'.
						"\n".'$l[\'Update completed.\'] = \''.addslashes($this->l('Update completed.')).'\';'.
						"\n".'$l[\'Update module\'] = \''.addslashes($this->l('Update module')).'\';'.
						"\n".'$l[\'Unable to obtain the database schema\'] = \''.addslashes($this->l('Unable to obtain the database schema')).'\';'.
						"\n".'$l[\'You already have the last version\'] = \''.addslashes($this->l('You already have the last version')).'\';'.
						'?>';
				if (@file_put_contents(dirname(__FILE__).DIRECTORY_SEPARATOR.'config.php', $text)) {
					$result['nextStep'] = $nextStep;
					$result['error'] = 0;
					switch ($nextStep) {
						case 'downloadPrestashop' :
							$result['information'] = $this->l('Download version').' '.$new_version[1].'...';
							break;
						case 'preRestoreDatabase' :
							$result['information'] = $this->l('Restore database...');
							break;
						case 'deleteBackup' :
							$result['information'] = $this->l('Delete backup...');
							break;
					}
					// clear the entire cache
					if (is_object($smarty)
						&& method_exists($smarty, 'clearAllCache'))
						$smarty->clearAllCache();
				} else {
					$result['nextStep'] = -1;
					$result['error'] = 1;
					$result['information'] = $this->l('Can\'t write config file');
				}
			} else {
				$result['nextStep'] = -1;
				$result['error'] = 1;
				$result['information'] = $this->l('Hack attempt');
			}
			
			return $result;
		}
		
		private function getHighterVersions() {
			$html = $this->file_get_contents('http://code.google.com/p/prestashop/downloads/list');
			$results = array();
			$result = array();
			if (preg_match_all('/col_1[^<]+.*prestashop_([0-9\.]+).zip&[^>]*>[^<^\d]*([^<]*)<\/a>/mi', $html, $results, PREG_SET_ORDER)) {
				foreach($results as $version) {
					$version[2] = str_replace('final', 'Final', $version[2]);
					if ($this->version_compare($version[1], _PS_VERSION_, '>')
						&& (!$this->config[$this->shortName.'_final']
							|| stripos($version[2], 'Final'))
					   )
						$result[trim($version[2])] = base64_encode('http://prestashop.googlecode.com/files/prestashop_'.$version[1].'.zip');
						// 2011-06-10 by Georges Cubas base64_encode for appache modsecurity. sometime it refuses http:// in url query
				}
			}
			
			natsort($result);
			return array_reverse($result);
		}
	
		private function getLastVersion() {
			$html = $this->file_get_contents('http://code.google.com/p/prestashop/downloads/list');
			$latestVersion = array(1=> _PS_VERSION_, 2=> _PS_VERSION_);
			if (preg_match_all('/col_1[^<]+.*prestashop_([0-9\.]+).zip&[^>]*>[^<^\d]*([^<]*)<\/a>/mi', $html, $results, PREG_SET_ORDER)) {
				foreach($results as $version) {
					$version[2] = str_replace('final', 'Final', $version[2]);
					if ($this->version_compare($version[1], $latestVersion[1], '>')
						&& (!$this->config[$this->shortName.'_final']
							|| stripos($version[2], 'Final'))
					   )
						$latestVersion = $version;
				}
			}
			return $latestVersion[2];
		}
		
		// @since 2.6.3.0
		private function file_get_contents($url) {
			$result = false;
			if (function_exists('curl_init'))
				$result = $this->file_get_contents_curl($url);
			elseif (@ini_get('allow_url_fopen'))
				$result = @file_get_contents($url);
			return $result;
		}
		
		/**
		 * Basic cURL wrapper function for PHP
		 * @link http://snipplr.com/view/51161/basic-curl-wrapper-function-for-php/
		 * @param string $url URL to fetch
		 * @param array $curlopt Array of options for curl_setopt_array
		 * @return string
		 */
		function file_get_contents_curl($url, $curlopt = array()){
			$ch = curl_init();
			$default_curlopt = array(
				CURLOPT_TIMEOUT => 300,
				CURLOPT_RETURNTRANSFER => 1,
				CURLOPT_USERAGENT => 'Module '.$this->name.' v'.$this->version.' for Prestashop v'._PS_VERSION_
			);
			$curlopt = array(CURLOPT_URL => $url) + $curlopt + $default_curlopt;
			curl_setopt_array($ch, $curlopt);
			$response = $this->curl_exec_follow($ch);
			if($response === false)
				trigger_error(curl_error($ch));
			curl_close($ch);
			return $response;
		}

		//http://www.php.net/manual/en/function.curl-setopt.php#102121
		// @since 2.7.1.0
		function curl_exec_follow(/*resource*/ $ch, /*int*/ $maxredirect = null) { 
			$mr = $maxredirect === null ? 5 : intval($maxredirect);
			if (ini_get('open_basedir') == '' && ini_get('safe_mode' == 'Off')) { 
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, $mr > 0); 
				curl_setopt($ch, CURLOPT_MAXREDIRS, $mr); 
			} else { 
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false); 
				if ($mr > 0) { 
					$newurl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL); 
		
					$rch = curl_init(); 
									
					$curlopt = array(
						CURLOPT_TIMEOUT => 600,
						CURLOPT_HEADER => true,
						CURLOPT_RETURNTRANSFER => true,
						CURLOPT_NOBODY => true,
						CURLOPT_FORBID_REUSE => false,
						CURLOPT_USERAGENT => 'Module '.$this->name.' v'.$this->version.' for Prestashop v'._PS_VERSION_
					);
					@curl_setopt_array($rch, $curlopt);
					do { 
						curl_setopt($rch, CURLOPT_URL, $newurl); 
						$header = curl_exec($rch); 
						if (curl_errno($rch)) { 
							$code = 0; 
						} else { 
							$code = curl_getinfo($rch, CURLINFO_HTTP_CODE); 
							if ($code == 301 || $code == 302) { 
								preg_match('/Location:(.*?)\n/', $header, $matches); 
								$newurl = trim(array_pop($matches)); 
							} else { 
								$code = 0; 
							} 
						} 
					} while ($code && --$mr); 
					curl_close($rch); 
					if (!$mr) { 
						if ($maxredirect === null) { 
							trigger_error('Too many redirects. When following redirects, libcurl hit the maximum amount.', E_USER_WARNING); 
						} else { 
							$maxredirect = 0; 
						} 
						return false; 
					} 
					curl_setopt($ch, CURLOPT_URL, $newurl); 
				} 
			} 
			return curl_exec($ch); 
		}

		/**
		 * like version_compare but 1.3 == 1.3.0.0
		 * 
		 * @see version_compare
		 * @since 2.6.0.0
		 * @param string $version1
		 * @param string $version2
		 * @param string $operator
		 * @return boolean
		 **/
		private function version_compare($version1, $version2, $operator) {
			$v1 = explode('.', $version1);
			$v2 = explode('.', $version2);
			if (count($v1) > count($v2))
				foreach ($v1 as $key => $value)
					if (!isset($v2[$key]))
						$v2[$key] = '0';
			
			if (count($v1) < count($v2))
				foreach ($v2 as $key => $value)
					if (!isset($v1[$key]))
						$v1[$key] = '0';
			
			return version_compare(implode('.', $v1), implode('.', $v2), $operator);
		}
		
		public function hookBackOfficeHome($params) {
			global $currentIndex, $cookie;
			$this->getConfig();
			$latestVersion = $this->getLastVersion();
			if ($latestVersion && version_compare($latestVersion, _PS_VERSION_, '>')) {
				$token = Tools::getAdminToken('AdminModules'.intval(Tab::getIdFromClassName('AdminModules')).intval($cookie->id_employee));
				$output = '<p class="warning">'.
						$this->l('Latest Prestashop version available is:').' <b>'.$latestVersion.'</b><br/>'.
						$this->l('Your Prestashop version is:').' <b>'._PS_VERSION_.'</b><br/>
						<a class="button" href="'.$currentIndex.'?tab=AdminModules&amp;configure='.$this->name.'&amp;token='.$token.'">'.$this->l('Update').'</a>
						</p>';
				return $output;
			}
		}
		
		private function setMaintenanceMode($status = true) {
			Configuration::updateValue('PS_SHOP_ENABLE', (int) $status);
		}
		
		function detect_apache_mod($name) {
			$save = ob_get_clean();
			ob_start();
			phpinfo();
			$phpinfo = ob_get_clean();
			if ($save !== false) {
				ob_start();
				echo $save;
			}
			return (strpos($phpinfo, $name) !== false);
		}
		
		// set default config
		// @since 2.6.3.0
		public function getDefaultConfig() {
			$result = array(
				$this->shortName.'_final' => 1, // show only final version
				$this->shortName.'_host' => '', // FTP host
				$this->shortName.'_login' => '', // FTP login
				$this->shortName.'_ftppass' => '', // FTP password
				$this->shortName.'_path' => '', // FTP path
				$this->shortName.'_password' => '',
				);
			
			return $result;
		}
		
		private function checkFTPConnection($host, $login, $password, $path) {
			$result = false;
			$conn_id = @ftp_connect($host);
			if ($conn_id) {
				$login_result = @ftp_login ($conn_id, $login?$login:'anonymous', $password); 
				if ($login_result) {
					if (!@ftp_chdir($conn_id , DIRECTORY_SEPARATOR.trim($path, DIRECTORY_SEPARATOR).DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.$this->name.DIRECTORY_SEPARATOR)) {
						$this->_postErrors[] = $this->l('Unable to find your shop on FTP, Please check your parameters');
					} else
						$result = true;
				} else {
					$this->_postErrors[] = $this->l('Unable to login to FTP, Please check your parameters');
				}
				ftp_close($conn_id);
			} else {
				$this->_postErrors[] = $this->l('Unable to connect to FTP, Please check your parameters');
			}
			return $result;
		}
	}
}

// from wordpress
// For PHP < 5.2.0
if ( !function_exists('json_encode') ) {
	require_once( _PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'easyupdate'.DIRECTORY_SEPARATOR.'classes'.DIRECTORY_SEPARATOR.'class-json.php' );
	function json_encode( $string ) {
		$wp_json = new Services_JSON();
		return $wp_json->encodeUnsafe( $string );
	}
}
?>
