<?php

include_once(dirname(__FILE__).'/../../../config/config.inc.php');
include_once(dirname(__FILE__).'/TVAUpdaterBase.php');

/*
*  2013 Neovis : Michael Jegou & Vasseur Alexandre
*
*  @author VASSEUR ALEXANDRE <tech@neovis.fr>
*  @author MJ <tech@neovis.fr>
*  @copyright  2013 Neovis
*  @license    not free
*  International Registered Trademark & Property of Neovis
*
* Classe appelée selon la version de prestashop
* Elle permet d'accéder à différent type de base de données
* version 1.4
* @TODO: include only in backoffice! to avoid conflicts with other modules using the same tip
*/

include_once(dirname(dirname(__FILE__)).'/classes/CompatibilityClass14.php');

class TVAUpdater extends TVAUpdaterBase
{

	/**
	* this function return admin token for all versions!
	*/
	public static function getAdminTokenLite($admin_page)
	{
		if (method_exists('Tools', 'getAdminTokenLite'))
			return Tools::getAdminTokenLite($admin_page);
		else
			return Tools::getAdminToken($admin_page.(int)Tab::getIdFromClassName($admin_page).(int)Context::getContext()->employee->id);
	}

	/**
	* Update needed tables
	*/
	public static function updateDB()
	{
		$ret = true;

		Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('SHOW COLUMNS FROM '._DB_PREFIX_.'tax LIKE "active"');
		if (Db::getInstance(_PS_USE_SQL_SLAVE_)->NumRows() < 1)
			$ret &= Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('ALTER TABLE `'._DB_PREFIX_.'tax` ADD `active` tinyint(1) unsigned NOT NULL DEFAULT \'1\'');

		Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('SHOW COLUMNS FROM '._DB_PREFIX_.'tax LIKE "deleted"');
		if (Db::getInstance(_PS_USE_SQL_SLAVE_)->NumRows() < 1)
			$ret &= Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('ALTER TABLE `'._DB_PREFIX_.'tax` ADD `deleted` tinyint(1) unsigned NOT NULL DEFAULT \'0\'');

		return $ret;
	}

	/**
	* Insert Data in DB
	*/
	public static function insertQuery($table, $values)
	{
		return Db::getInstance()->autoExecute(_DB_PREFIX_.$table, $values, 'INSERT');
	}

	/**
	* Update Data in DB
	*/
	public static function updateQuery($table, $values, $where)
	{
		return Db::getInstance()->autoExecute(_DB_PREFIX_.$table, $values, 'UPDATE', $where);
	}

	/**
	* Get all available taxes
	*
	* @return array Taxes
	*/
	public static function getTaxes($id_lang = false, $active_only = true, $not_deleted_only = true)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
		SELECT t.id_tax, t.rate, t.active, t.deleted'.((int)$id_lang ? ', tl.name, tl.id_lang ' : '').'
		FROM `'._DB_PREFIX_.'tax` t
		'.((int)$id_lang ? 'LEFT JOIN `'._DB_PREFIX_.'tax_lang` tl ON (t.`id_tax` = tl.`id_tax` AND tl.`id_lang` = '.(int)$id_lang.')'
		.($active_only == 1 ? 'WHERE t.`active` = 1' : '')
		.($not_deleted_only == 1 ? 'WHERE t.`deleted` = 1' : '')
		.' ORDER BY t.deleted ASC, t.active DESC, t.`id_tax` ASC' : ''));
	}

/********************************************************************************************
 *	Fonction qui récupere la liste des produits par boutique à partir d'un id_produit
 ********************************************************************************************/
	public static function getProductsShopByTaxId($id_product)
	{
		$id_product = $id_product; // just for validator....
		return false;
	}

/********************************************************************************************
 *	Fonction qui récupere la liste des déclinaisons par boutique à partir d'un id_produit
 ********************************************************************************************/
	public static function getProductsAttributesShopByTaxId($id_product)
	{
		$id_product = $id_product; // just for validator....
		return false;
	}

/********************************************************************************************
 *	Fonction qui récupere le nombre de transporteurs en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getNbCarriersByTax($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('
			SELECT count(DISTINCT id_carrier) as count
			FROM '._DB_PREFIX_.'carrier
			WHERE id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')');
	}

/********************************************************************************************
 *	Fonction qui récupere la liste des transporteurs en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getCArriersByTax($tax_id = null)
	{
		// 	Récuperer la langue par défaut
		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

		//	la requete
		$carriers = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT *
			FROM '._DB_PREFIX_.'carrier c
			LEFT JOIN '._DB_PREFIX_.'carrier_tax_rules_group ctrg
			ON c.id_carrier = ctrg.id_carrier
			WHERE ctrg.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')');

	//	print'<pre>';print_r($carriers);print'</pre>';
		return $carriers;
	}

/********************************************************************************************
 *	Fonction qui récupere le nombre de règles de taxe en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getNbOrdersByTax($tax_id = null)
	{
		$tax = new Tax($tax_id);

		return Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('
			SELECT count(DISTINCT ot.id_order) as count
			FROM '._DB_PREFIX_.'order_tax ot
			WHERE ot.tax_rate = "'.(float)$tax->rate.'"');
	}

/********************************************************************************************
 *	fonction pour update Value de configuration qui marche de partout 1.4
 ********************************************************************************************/
	public static function updateConfigurationValue($name, $value = '')
	{
		Configuration::updateValue($name, $value);
	}

}
