<?php
/*
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2014 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

include_once(dirname(__FILE__).'/../../../config/config.inc.php');
include_once(dirname(__FILE__).'/../../../init.php');

include_once(_PS_MODULE_DIR_.'paypal/express_checkout/process.php');
include_once(_PS_MODULE_DIR_.'paypal/express_checkout/submit.php');

/* Normal payment process */
$id_cart = Tools::getValue('id_cart');
$id_order = Tools::getValue('id_order');
$id_module = Tools::getValue('id_module');
$paypal_key = Tools::getValue('key');

if ($id_cart && $id_order && $id_module && $paypal_key)
{
	if (version_compare(_PS_VERSION_, '1.5', '<'))
		new PayPalExpressCheckoutSubmit();
	return;
}

$request_type = Tools::getValue('express_checkout');
$ppec = new PaypalExpressCheckout($request_type);

$token = Tools::getValue('token');
$payer_id = Tools::getValue('PayerID');

function setContextData($ppec)
{
	// Create new Cart to avoid any refresh or other bad manipulations
	$ppec->context->cart = new Cart();
	$ppec->context->cart->id_currency = (int)$ppec->context->currency->id;
	$ppec->context->cart->id_lang = (int)$ppec->context->language->id;
	
	// Customer settings
	$ppec->context->cart->id_guest = (int)$ppec->context->cookie->id_guest;
	$ppec->context->cart->id_customer = (int)$ppec->context->customer->id;
	
	// Secure key information
	$secure_key = isset($ppec->context->customer) ? $ppec->context->customer->secure_key : null;
	$ppec->context->cart->secure_key = $secure_key;
}

/**
 * Set customer information
 * Used to create user account with PayPal account information
 */
function setCustomerInformation($ppec, $email)
{
	$customer = new Customer();
	$customer->email = $email;
	$customer->lastname = $ppec->result['LASTNAME'];
	$customer->firstname = $ppec->result['FIRSTNAME'];
	$customer->passwd = Tools::encrypt(Tools::passwdGen());
	return $customer;
}


/**
 * Set customer address (when not logged in)
 * Used to create user address with PayPal account information
 */
function setCustomerAddress($ppec, $customer, $id = null)
{
	$address = new Address($id);
	$address->id_country = Country::getByIso($ppec->result['COUNTRYCODE']);
	$address->alias = 'Paypal_Address';
	$address->lastname = $customer->lastname;
	$address->firstname = $customer->firstname;
	$address->address1 = $ppec->result['PAYMENTREQUEST_0_SHIPTOSTREET'];
	if (isset($ppec->result['PAYMENTREQUEST_0_SHIPTOSTREET2']))
		$address->address2 = $ppec->result['PAYMENTREQUEST_0_SHIPTOSTREET2'];
	$address->city = $ppec->result['PAYMENTREQUEST_0_SHIPTOCITY'];
	$address->id_state = (int)State::getIdByIso($ppec->result['SHIPTOSTATE'], $address->id_country);
	$address->postcode = $ppec->result['SHIPTOZIP'];
	$address->id_customer = $customer->id;
	return $address;
}

if ($request_type && $ppec->type)
{
	$id_product = (int)Tools::getValue('id_product');
	$product_quantity = (int)Tools::getValue('quantity');
	$id_product_attribute = Tools::getValue('id_p_attr');

	if (($id_product > 0) && $id_product_attribute !== false && ($product_quantity > 0))
	{
		setContextData($ppec);

		if (!$ppec->context->cart->add())
		{
			$ppec->logs[] = $ppec->l('Cannot create new cart');
			$display = (_PS_VERSION_ < '1.5') ? new BWDisplay() : new FrontController();
				
			$ppec->context->smarty->assign(array(
					'logs' => $ppec->logs,
					'message' => $ppec->l('Error occurred:'),
					'use_mobile' => (bool)$ppec->useMobile()
					));
			
			$template = 'error.tpl';
		}
		else
			$ppec->context->cookie->id_cart = (int)$ppec->context->cart->id;

		$ppec->context->cart->updateQty((int)$product_quantity, (int)$id_product, (int)$id_product_attribute);
		$ppec->context->cart->update();
	}

	/* Set details for a payment */
	$ppec->setExpressCheckout();

	if ($ppec->hasSucceedRequest() && !empty($ppec->token))
		$ppec->redirectToAPI();
	/* Display Error and die                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       